package ru.yandex.direct.grid.processing.service.group.type;

import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableMap;

import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;
import ru.yandex.direct.grid.processing.model.group.GdAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdContentPromotionAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmAudioAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmBannerAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmGeoPinAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmGeoproductAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmIndoorAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmOutdoorAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmPriceAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmPriceAudioAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmPriceBannerAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmPriceVideoAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmVideoAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmYndxFrontpageAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdDynamicAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdMcBannerAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdMobileContentAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdSmartAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdTextAdGroup;

import static com.google.common.base.Preconditions.checkState;

@ParametersAreNonnullByDefault
public class GdAdGroupTypeAssertionsMap {
    private static final Map<GdAdGroupType, Class<? extends GdAdGroup>> classByType =
            ImmutableMap.<GdAdGroupType, Class<? extends GdAdGroup>>builder()
                    .put(GdAdGroupType.TEXT, GdTextAdGroup.class)
                    .put(GdAdGroupType.MOBILE_CONTENT, GdMobileContentAdGroup.class)
                    .put(GdAdGroupType.DYNAMIC, GdDynamicAdGroup.class)
                    .put(GdAdGroupType.PERFORMANCE, GdSmartAdGroup.class)
                    .put(GdAdGroupType.MCBANNER, GdMcBannerAdGroup.class)
                    .put(GdAdGroupType.CPM_VIDEO, GdCpmVideoAdGroup.class)
                    .put(GdAdGroupType.CPM_AUDIO, GdCpmAudioAdGroup.class)
                    .put(GdAdGroupType.CPM_BANNER, GdCpmBannerAdGroup.class)
                    .put(GdAdGroupType.CPM_INDOOR, GdCpmIndoorAdGroup.class)
                    .put(GdAdGroupType.CPM_OUTDOOR, GdCpmOutdoorAdGroup.class)
                    .put(GdAdGroupType.CPM_GEOPRODUCT, GdCpmGeoproductAdGroup.class)
                    .put(GdAdGroupType.CPM_PRICE, GdCpmPriceAdGroup.class)
                    .put(GdAdGroupType.CPM_PRICE_VIDEO, GdCpmPriceVideoAdGroup.class)
                    .put(GdAdGroupType.CPM_PRICE_FRONTPAGE_VIDEO, GdCpmPriceVideoAdGroup.class)
                    .put(GdAdGroupType.CPM_PRICE_AUDIO, GdCpmPriceAudioAdGroup.class)
                    .put(GdAdGroupType.CPM_PRICE_BANNER, GdCpmPriceBannerAdGroup.class)
                    .put(GdAdGroupType.CPM_YNDX_FRONTPAGE, GdCpmYndxFrontpageAdGroup.class)
                    .put(GdAdGroupType.INTERNAL, GdInternalAdGroup.class)
                    .put(GdAdGroupType.CONTENT_PROMOTION, GdContentPromotionAdGroup.class)
                    .put(GdAdGroupType.CONTENT_PROMOTION_VIDEO, GdContentPromotionAdGroup.class)
                    .put(GdAdGroupType.CONTENT_PROMOTION_COLLECTION, GdContentPromotionAdGroup.class)
                    .put(GdAdGroupType.CONTENT_PROMOTION_SERVICE, GdContentPromotionAdGroup.class)
                    .put(GdAdGroupType.CONTENT_PROMOTION_EDA, GdContentPromotionAdGroup.class)
                    .put(GdAdGroupType.CPM_GEO_PIN, GdCpmGeoPinAdGroup.class)
                    .build();

    /**
     * Проверить, соответствует ли указанный тип группы классу переданного объекта.
     *
     * @param gdAdGroup группа
     * @param <G>       тип модели
     */
    public static <G extends GdAdGroup> void assertGdAdGroupHasConsistentType(G gdAdGroup) {
        Class<?> validClass = validClassOf(gdAdGroup);
        checkState(validClass != null, "No class specified for gdAdGroup of type %s", gdAdGroup.getType());
        checkState(validClass.isAssignableFrom(gdAdGroup.getClass()),
                "GdAdGroup.type does not match class of the gdAdGroup object:%n%s", gdAdGroup);
    }

    @Nullable
    private static <G extends GdAdGroup> Class<? extends GdAdGroup> validClassOf(G gdAdGroup) {
        return classByType.get(gdAdGroup.getType());
    }
}
