package ru.yandex.direct.grid.processing.service.group.type;

import java.util.Collection;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;
import ru.yandex.direct.grid.processing.model.group.GdAdGroup;

/**
 * В зависимости от типа группы, логика заполнения некоторых полей может отличаться,
 * интерфейс содержит методы специфичные для заполнения групп разных типов
 */
public interface GroupTypeSupport<G extends GdAdGroup> {
    GdAdGroupType getAdGroupType();

    void setAvailableShowConditionTypesForAdGroup(int shard, ClientId clientId, Long operatorUid,
                                                  Collection<G> adGroups);

    void setAvailableBannerTypesForAdGroup(int shard, ClientId clientId, Collection<G> adGroups);
}
