package ru.yandex.direct.grid.processing.service.group.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;
import ru.yandex.direct.grid.processing.model.banner.GdAdType;
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroup;

import static java.util.Collections.emptySet;
import static java.util.Collections.singleton;

@Component
@ParametersAreNonnullByDefault
public class InternalGroupTypeSupport implements GroupTypeSupport<GdInternalAdGroup> {
    @Override
    public GdAdGroupType getAdGroupType() {
        return GdAdGroupType.INTERNAL;
    }

    @Override
    public void setAvailableShowConditionTypesForAdGroup(int shard, ClientId clientId, Long operatorUid,
                                                         Collection<GdInternalAdGroup> adGroups) {
        adGroups.forEach(adGroup -> adGroup.setAvailableShowConditionTypes(emptySet()));
    }

    @Override
    public void setAvailableBannerTypesForAdGroup(int shard, ClientId clientId,
                                                  Collection<GdInternalAdGroup> adGroups) {
        adGroups.forEach(adGroup -> adGroup.setAvailableAdTypes(singleton(GdAdType.INTERNAL)));
    }
}
