package ru.yandex.direct.grid.processing.service.group.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;
import ru.yandex.direct.grid.processing.model.banner.GdAdType;
import ru.yandex.direct.grid.processing.model.group.GdMcBannerAdGroup;
import ru.yandex.direct.grid.processing.model.showcondition.GdShowConditionType;

@Component
@ParametersAreNonnullByDefault
public class McBannerGroupTypeSupport implements GroupTypeSupport<GdMcBannerAdGroup> {
    @Override
    public void setAvailableShowConditionTypesForAdGroup(int shard, ClientId clientId,
                                                         Long operatorUid, Collection<GdMcBannerAdGroup> adGroups) {
        adGroups.forEach(adGroup -> adGroup.setAvailableShowConditionTypes(
                ImmutableSet.of(GdShowConditionType.KEYWORD)));
    }

    @Override
    public GdAdGroupType getAdGroupType() {
        return GdAdGroupType.MCBANNER;
    }

    @Override
    public void setAvailableBannerTypesForAdGroup(int shard, ClientId clientId,
                                                  Collection<GdMcBannerAdGroup> adGroups) {
        adGroups.forEach(adGroup -> adGroup.setAvailableAdTypes(ImmutableSet.of(GdAdType.MCBANNER)));
    }
}
