package ru.yandex.direct.grid.processing.service.group.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;
import ru.yandex.direct.grid.processing.model.banner.GdAdType;
import ru.yandex.direct.grid.processing.model.group.GdTextAdGroup;
import ru.yandex.direct.grid.processing.model.showcondition.GdShowConditionType;

@Component
@ParametersAreNonnullByDefault
public class TextGroupTypeSupport implements GroupTypeSupport<GdTextAdGroup> {
    @Override
    public void setAvailableShowConditionTypesForAdGroup(int shard, ClientId clientId, Long operatorUid,
                                                         Collection<GdTextAdGroup> adGroups) {
        adGroups.forEach(adGroup -> adGroup.setAvailableShowConditionTypes(
                ImmutableSet.of(
                        GdShowConditionType.RELEVANCE_MATCH,
                        GdShowConditionType.KEYWORD,
                        GdShowConditionType.RETARGETING,
                        GdShowConditionType.MOBILE_INTERESTS
                )));
    }

    @Override
    public GdAdGroupType getAdGroupType() {
        return GdAdGroupType.TEXT;
    }

    @Override
    public void setAvailableBannerTypesForAdGroup(int shard, ClientId clientId, Collection<GdTextAdGroup> adGroups) {
        adGroups.forEach(adGroup -> adGroup.setAvailableAdTypes(ImmutableSet.of(GdAdType.TEXT, GdAdType.IMAGE_AD)));
    }
}
