package ru.yandex.direct.grid.processing.service.group.type.contentpromotion;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;
import ru.yandex.direct.grid.processing.model.group.GdContentPromotionAdGroup;
import ru.yandex.direct.grid.processing.model.showcondition.GdShowConditionType;
import ru.yandex.direct.grid.processing.service.group.type.ContentPromotionGroupTypeSupport;

@Component
@ParametersAreNonnullByDefault
public class ContentPromotionServiceGroupTypeSupport extends ContentPromotionGroupTypeSupport {

    private static final Set<GdShowConditionType> AVAILABLE_SHOW_CONDITION_TYPES = ImmutableSet.of(
            GdShowConditionType.RELEVANCE_MATCH,
            GdShowConditionType.KEYWORD
    );

    @Override
    public GdAdGroupType getAdGroupType() {
        return GdAdGroupType.CONTENT_PROMOTION_SERVICE;
    }

    @Override
    public void setAvailableShowConditionTypesForAdGroup(int shard, ClientId clientId, Long operatorUid,
                                                         Collection<GdContentPromotionAdGroup> adGroups) {
        adGroups.forEach(adGroup -> adGroup.setAvailableShowConditionTypes(AVAILABLE_SHOW_CONDITION_TYPES));
    }
}
