package ru.yandex.direct.grid.processing.service.group.validation;

import java.util.List;

import ru.yandex.direct.grid.processing.model.crypta.GdCryptaGoalsSuggestItem;
import ru.yandex.direct.grid.processing.model.crypta.GdCryptaGoalsSuggestType;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddContentPromotionAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddMobileContentAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateAdGroupRetargetingItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateContentPromotionAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateMobileContentAdGroupItem;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.constraint.CommonConstraints;
import ru.yandex.direct.validation.defect.CollectionDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CollectionConstraints.maxListSize;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.minListSize;

class AdGroupValidationUtils {

    /**
     * Проверка на консистентность данных, пришедших с фронта. Ключевые фразы должны либо не приходить совсем, либо
     * приходить без null-ов.
     */
    static Constraint<List<GdAddContentPromotionAdGroupItem>, Defect> checkKeywordsUniformityForAdd() {
        return Constraint.fromPredicate(
                list -> list.stream().allMatch(item -> item.getKeywords() != null) ||
                        list.stream().allMatch(item -> item.getKeywords() == null), CollectionDefects.notContainNulls());
    }

    /**
     * Проверка на консистентность данных, пришедших с фронта. Автотаргетинги должны либо не приходить совсем, либо
     * приходить без null-ов.
     */
    static Constraint<List<GdAddContentPromotionAdGroupItem>, Defect> checkRelevanceMatchUniformityForAdd() {
        return Constraint.fromPredicate(
                list -> list.stream().allMatch(item -> item.getRelevanceMatch() != null) ||
                        list.stream().allMatch(item -> item.getRelevanceMatch() == null), CollectionDefects.notContainNulls());
    }

    /**
     * Проверка на консистентность данных, пришедших с фронта. Ключевые фразы должны либо не приходить совсем, либо
     * приходить без null-ов.
     */
    static Constraint<List<GdUpdateContentPromotionAdGroupItem>, Defect> checkKeywordsUniformityForUpdate() {
        return Constraint.fromPredicate(
                list -> list.stream().allMatch(item -> item.getKeywords() != null) ||
                        list.stream().allMatch(item -> item.getKeywords() == null), CollectionDefects.notContainNulls());
    }

    /**
     * Проверка на консистентность данных, пришедших с фронта. Автотаргетинги должны либо не приходить совсем, либо
     * приходить без null-ов.
     */
    static Constraint<List<GdUpdateContentPromotionAdGroupItem>, Defect> checkRelevanceMatchUniformityForUpdate() {
        return Constraint.fromPredicate(
                list -> list.stream().allMatch(item -> item.getRelevanceMatch() != null) ||
                        list.stream().allMatch(item -> item.getRelevanceMatch() == null), CollectionDefects.notContainNulls());
    }

    /**
     * Проверка на консистентность данных, пришедших с фронта. Ключевые фразы должны либо не приходить совсем, либо
     * приходить без null-ов.
     */
    static Constraint<List<GdAddMobileContentAdGroupItem>, Defect> checkKeywordsUniformityForAddMobileContent() {
        return Constraint.fromPredicate(
                list -> list.stream().allMatch(item -> item.getKeywords() != null) ||
                        list.stream().allMatch(item -> item.getKeywords() == null), CollectionDefects.notContainNulls());
    }

    static Constraint<List<GdUpdateMobileContentAdGroupItem>, Defect> checkKeywordsUniformityForUpdateMobileContent() {
        return Constraint.fromPredicate(
                list -> list.stream().allMatch(item -> item.getKeywords() != null) ||
                        list.stream().allMatch(item -> item.getKeywords() == null), CollectionDefects.notContainNulls());
    }

    /**
     * Проверка на консистентность данных, пришедших с фронта. Автотаргетинги должны либо не приходить совсем, либо
     * приходить без null-ов.
     */
    static Constraint<List<GdAddMobileContentAdGroupItem>, Defect> checkRelevanceMatchUniformityForAddMobileContent() {
        return Constraint.fromPredicate(
                list -> list.stream().allMatch(item -> item.getRelevanceMatch() != null)
                        || list.stream().allMatch(item -> item.getRelevanceMatch() == null),
                CollectionDefects.notContainNulls());
    }

    static Constraint<List<GdUpdateMobileContentAdGroupItem>, Defect> checkRelevanceMatchUniformityForUpdateMobileContent() {
        return Constraint.fromPredicate(
                list -> list.stream().allMatch(item -> item.getRelevanceMatch() != null)
                        || list.stream().allMatch(item -> item.getRelevanceMatch() == null),
                CollectionDefects.notContainNulls());
    }

    static final Validator<GdUpdateAdGroupRetargetingItem, Defect> RETARGETING_ITEM_VALIDATOR = retargeting -> {
        ModelItemValidationBuilder<GdUpdateAdGroupRetargetingItem> vb = ModelItemValidationBuilder.of(retargeting);

        vb.item(GdUpdateAdGroupRetargetingItem.RET_COND_ID)
                .check(CommonConstraints.validId());
        return vb.getResult();
    };

    static final Validator<List<GdCryptaGoalsSuggestItem>, Defect> CA_RETARGETING_ITEM_VALIDATOR = items ->
            ListValidationBuilder.of(items, Defect.class)
            .checkEachBy(
                    AdGroupValidationUtils.CRYPTA_SUGGEST_VALIDATOR,
                    When.valueIs(item -> item.getType() == GdCryptaGoalsSuggestType.SEGMENT)
            ).getResult();

    private static final Validator<GdCryptaGoalsSuggestItem, Defect> CRYPTA_SUGGEST_VALIDATOR = item -> {
        var vb = ModelItemValidationBuilder.of(item);

        vb.list(GdCryptaGoalsSuggestItem.SEGMENTS)
                .check(minListSize(1))
                .check(maxListSize(2));

        return vb.getResult();
    };
}
