package ru.yandex.direct.grid.processing.service.hypergeo;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLContext;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.client.GdClient;
import ru.yandex.direct.grid.processing.model.hypergeo.GdHyperGeoPayload;
import ru.yandex.direct.grid.processing.model.hypergeo.GdHyperGeoRetargetingContainer;
import ru.yandex.direct.grid.processing.service.hypergeo.service.HyperGeoDataService;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class HyperGeoGraphQlService {

    private final HyperGeoDataService hyperGeoDataService;

    @Autowired
    public HyperGeoGraphQlService(HyperGeoDataService hyperGeoDataService) {
        this.hyperGeoDataService = hyperGeoDataService;
    }

    @GraphQLNonNull
    @GraphQLQuery(name = "hyperGeo")
    public GdHyperGeoPayload getHyperGeo(
            @GraphQLRootContext GridGraphQLContext context,
            @SuppressWarnings("unused") @GraphQLContext GdClient client,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdHyperGeoRetargetingContainer input) {

        return hyperGeoDataService.getHyperGeo(context, input);
    }
}
