package ru.yandex.direct.grid.processing.service.hypergeo;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.hypergeo.mutation.createhypergeo.GdCreateHyperGeos;
import ru.yandex.direct.grid.processing.model.hypergeo.mutation.createhypergeo.GdCreateHyperGeosPayload;
import ru.yandex.direct.grid.processing.model.hypergeo.mutation.createhypergeosegment.GdCreateHyperGeoSegments;
import ru.yandex.direct.grid.processing.model.hypergeo.mutation.createhypergeosegment.GdCreateHyperGeoSegmentsPayload;
import ru.yandex.direct.grid.processing.service.hypergeo.service.HyperGeoMutationService;
import ru.yandex.direct.utils.CommonUtils;

import static com.google.common.base.Preconditions.checkNotNull;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class HyperGeoMutationGraphQlService {

    private final HyperGeoMutationService hyperGeoMutationService;
    private final FeatureService featureService;

    @Autowired
    public HyperGeoMutationGraphQlService(HyperGeoMutationService hyperGeoMutationService,
                                          FeatureService featureService) {
        this.hyperGeoMutationService = hyperGeoMutationService;
        this.featureService = featureService;
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "createHyperGeoSegments")
    public GdCreateHyperGeoSegmentsPayload createHyperGeoSegments(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdCreateHyperGeoSegments input) {
        User operator = context.getOperator();

        ClientId clientId = checkNotNull(context.getSubjectUser()).getClientId();

        String login = CommonUtils.nvl(context.getSubjectUser().getLogin(), operator.getLogin());
        return hyperGeoMutationService.createHyperGeoSegments(clientId, login, input);
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "createHyperGeos")
    public GdCreateHyperGeosPayload createHyperGeos(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdCreateHyperGeos input) {
        ClientId clientId = checkNotNull(context.getSubjectUser()).getClientId();

        return hyperGeoMutationService.createHyperGeos(clientId, input);
    }
}
