package ru.yandex.direct.grid.processing.service.hypergeo;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.hypergeo.model.GeoSegmentType;
import ru.yandex.direct.core.entity.hypergeo.model.HyperGeo;
import ru.yandex.direct.core.entity.hypergeo.model.HyperGeoSegment;
import ru.yandex.direct.core.entity.hypergeo.model.HyperGeoSegmentDetails;
import ru.yandex.direct.core.entity.hypergeo.model.HyperGeoSimple;
import ru.yandex.direct.core.entity.hypergeo.model.HyperPoint;
import ru.yandex.direct.grid.processing.model.hypergeo.GdAdGroupHyperGeo;
import ru.yandex.direct.grid.processing.model.hypergeo.GdGeoSegmentType;
import ru.yandex.direct.grid.processing.model.hypergeo.GdHyperGeo;
import ru.yandex.direct.grid.processing.model.hypergeo.GdHyperGeoPayload;
import ru.yandex.direct.grid.processing.model.hypergeo.GdHyperGeoSegment;
import ru.yandex.direct.grid.processing.model.hypergeo.GdHyperPoint;
import ru.yandex.direct.grid.processing.model.hypergeo.GdHyperRegion;
import ru.yandex.direct.grid.processing.model.hypergeo.mutation.createhypergeo.GdCreateHyperGeo;
import ru.yandex.direct.grid.processing.model.hypergeo.mutation.createhypergeosegment.GdCreateHyperGeoSegment;

import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class HyperGeoUtils {

    public static GdHyperRegion convert(HyperGeoSegment hyperGeoSegment) {
        return new GdHyperRegion()
                .withHyperRegionId(hyperGeoSegment.getId())
                .withClientId(hyperGeoSegment.getClientId())
                .withHyperGeoSegment(convert(hyperGeoSegment.getSegmentDetails()))
                .withCoveringGeo(hyperGeoSegment.getCoveringGeo());
    }

    public static GdHyperGeoSegment convert(HyperGeoSegmentDetails hyperGeoSegmentDetails) {
        var geoSegmentType = nvl(hyperGeoSegmentDetails.getGeoSegmentType(), GeoSegmentType.REGULAR);
        var gdGeoSegmentType = GdGeoSegmentType.fromSource(geoSegmentType);

        return new GdHyperGeoSegment()
                .withSegmentName(hyperGeoSegmentDetails.getSegmentName())
                .withRadius(hyperGeoSegmentDetails.getRadius())
                .withPoints(mapList(hyperGeoSegmentDetails.getPoints(), HyperGeoUtils::convert))
                .withPeriodLength(hyperGeoSegmentDetails.getPeriodLength())
                .withTimesQuantity(hyperGeoSegmentDetails.getTimesQuantity())
                .withGeoSegmentType(gdGeoSegmentType);
    }

    public static GdHyperPoint convert(HyperPoint hyperPoint) {
        return new GdHyperPoint()
                .withLatitude(hyperPoint.getLatitude())
                .withLongitude(hyperPoint.getLongitude())
                .withAddress(hyperPoint.getAddress());
    }

    public static HyperPoint convert(GdHyperPoint gdHyperPoint) {
        return new HyperPoint()
                .withLatitude(gdHyperPoint.getLatitude())
                .withLongitude(gdHyperPoint.getLongitude())
                .withAddress(gdHyperPoint.getAddress());
    }

    public static HyperGeoSegmentDetails convert(GdCreateHyperGeoSegment gdCreateHyperGeoSegment) {
        var gdGeoSegmentType = nvl(gdCreateHyperGeoSegment.getGeoSegmentType(), GdGeoSegmentType.REGULAR);
        var geoSegmentType = GdGeoSegmentType.toSource(gdGeoSegmentType);

        return new HyperGeoSegmentDetails()
                .withSegmentName(gdCreateHyperGeoSegment.getSegmentName())
                .withRadius(gdCreateHyperGeoSegment.getRadius())
                .withPoints(mapList(gdCreateHyperGeoSegment.getPoints(), HyperGeoUtils::convert))
                .withPeriodLength(gdCreateHyperGeoSegment.getPeriodLength())
                .withTimesQuantity(gdCreateHyperGeoSegment.getTimesQuantity())
                .withGeoSegmentType(geoSegmentType);
    }

    public static HyperGeoSimple convert(GdCreateHyperGeo gdCreateHyperGeo) {
        return new HyperGeoSimple()
                .withName(gdCreateHyperGeo.getHyperGeoName())
                .withHyperGeoSegmentIds(gdCreateHyperGeo.getHyperGeoSegmentIds());
    }

    public static GdHyperGeo convert(HyperGeo hyperGeo) {
        return new GdHyperGeo()
                .withHyperGeoId(hyperGeo.getId())
                .withHyperGeoName(hyperGeo.getName())
                .withHyperRegions(mapList(hyperGeo.getHyperGeoSegments(), HyperGeoUtils::convert));
    }

    public static GdAdGroupHyperGeo convert(Long adGroupId, HyperGeo hyperGeo) {
        GdHyperGeo gdHyperGeo = convert(hyperGeo);

        return new GdAdGroupHyperGeo()
                .withAdGroupId(adGroupId)
                .withAdGroupHyperGeo(gdHyperGeo);
    }

    public static GdHyperGeoPayload convertToPayload(Map<Long, HyperGeo> hyperGeoByAdGroupId) {
        return new GdHyperGeoPayload()
                .withRowset(convertToRowset(hyperGeoByAdGroupId));
    }

    public static List<GdAdGroupHyperGeo> convertToRowset(Map<Long, HyperGeo> hyperGeoByAdGroupId) {
        return EntryStream.of(hyperGeoByAdGroupId)
                .mapKeyValue(HyperGeoUtils::convert)
                .toList();
    }
}
