package ru.yandex.direct.grid.processing.service.hypergeo.service;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.hypergeo.model.HyperGeo;
import ru.yandex.direct.core.entity.hypergeo.service.HyperGeoService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.client.GdClientInfo;
import ru.yandex.direct.grid.processing.model.hypergeo.GdHyperGeoPayload;
import ru.yandex.direct.grid.processing.model.hypergeo.GdHyperGeoRetargetingContainer;

import static ru.yandex.direct.grid.processing.service.hypergeo.HyperGeoUtils.convertToPayload;

@Service
@ParametersAreNonnullByDefault
public class HyperGeoDataService {

    private final HyperGeoService hyperGeoService;

    @Autowired
    public HyperGeoDataService(HyperGeoService hyperGeoService) {
        this.hyperGeoService = hyperGeoService;
    }

    public GdHyperGeoPayload getHyperGeo(GridGraphQLContext context, GdHyperGeoRetargetingContainer input) {
        GdClientInfo client = context.getQueriedClient();
        ClientId clientId = ClientId.fromLong(client.getId());

        Map<Long, HyperGeo> hyperGeoByAdGroupId =
                hyperGeoService.getHyperGeoByAdGroupId(clientId, input.getFilter().getAdGroupIdIn());

        return convertToPayload(hyperGeoByAdGroupId);
    }
}
