package ru.yandex.direct.grid.processing.service.hypergeo.service;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.grid.processing.model.hypergeo.mutation.createhypergeo.GdCreateHyperGeo;
import ru.yandex.direct.grid.processing.model.hypergeo.mutation.createhypergeo.GdCreateHyperGeos;
import ru.yandex.direct.grid.processing.model.hypergeo.mutation.createhypergeosegment.GdCreateHyperGeoSegment;
import ru.yandex.direct.grid.processing.model.hypergeo.mutation.createhypergeosegment.GdCreateHyperGeoSegments;
import ru.yandex.direct.grid.processing.service.validation.GridValidationService;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupConstraints.MAX_GEO_SEGMENTS_COUNT_WITH_FEATURE_IN_HYPER_GEO;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.maxListSize;

@Service
@ParametersAreNonnullByDefault
public class HyperGeoMutationValidationService {

    private static final int MAX_HYPER_GEO_CREATED_IN_REQUEST = 1;
    private static final int MAX_POINTS_COUNT_IN_GEO_SEGMENT = 1;

    private final GridValidationService gridValidationService;

    @Autowired
    public HyperGeoMutationValidationService(GridValidationService gridValidationService) {
        this.gridValidationService = gridValidationService;
    }

    // Validate create hyper geo segments

    public void validateCreateHyperGeoSegments(GdCreateHyperGeoSegments input) {
        gridValidationService.applyValidator(this::validateHyperGeoSegments, input, false);
    }

    private ValidationResult<GdCreateHyperGeoSegments, Defect> validateHyperGeoSegments(GdCreateHyperGeoSegments input) {
        ModelItemValidationBuilder<GdCreateHyperGeoSegments> ivb = ModelItemValidationBuilder.of(input);

        ivb.list(GdCreateHyperGeoSegments.CREATE_HYPER_GEO_SEGMENT_ITEMS)
                .checkEachBy(this::validateHyperGeoSegment);

        return ivb.getResult();
    }

    private ValidationResult<GdCreateHyperGeoSegment, Defect> validateHyperGeoSegment(GdCreateHyperGeoSegment hyperGeoSegment) {
        ModelItemValidationBuilder<GdCreateHyperGeoSegment> ivb = ModelItemValidationBuilder.of(hyperGeoSegment);

        ivb.list(GdCreateHyperGeoSegment.POINTS)
                .check(maxListSize(MAX_POINTS_COUNT_IN_GEO_SEGMENT));

        return ivb.getResult();
    }

    // Validate create hyper geos

    public void validateCreateHyperGeos(GdCreateHyperGeos input) {
        gridValidationService.applyValidator(this::validateHyperGeos, input, false);
    }

    private ValidationResult<GdCreateHyperGeos, Defect> validateHyperGeos(GdCreateHyperGeos input) {
        ModelItemValidationBuilder<GdCreateHyperGeos> ivb = ModelItemValidationBuilder.of(input);

        ivb.list(GdCreateHyperGeos.CREATE_HYPER_GEO_ITEMS)
                .check(maxListSize(MAX_HYPER_GEO_CREATED_IN_REQUEST))
                .checkEachBy(this::validateHyperGeo);

        return ivb.getResult();
    }

    private ValidationResult<GdCreateHyperGeo, Defect> validateHyperGeo(GdCreateHyperGeo hyperGeo) {
        ModelItemValidationBuilder<GdCreateHyperGeo> ivb = ModelItemValidationBuilder.of(hyperGeo);

        ivb.list(GdCreateHyperGeo.HYPER_GEO_SEGMENT_IDS)
                .check(maxListSize(MAX_GEO_SEGMENTS_COUNT_WITH_FEATURE_IN_HYPER_GEO));

        return ivb.getResult();
    }
}
