package ru.yandex.direct.grid.processing.service.internalad

interface FieldOperations<V, U> {
    fun extract(obj: U): List<V>
    fun add(obj: U, value: V)
    fun remove(obj: U, value: V)
}

interface MassUpdateFieldSupport<OBJ, VAL, STATE, CHANGE> {
    val operations: FieldOperations<VAL, OBJ>

    fun convertToGdFieldState(value: VAL): STATE
    fun extractInputInnerValue(input: CHANGE): VAL?

    fun applyAdd(objects: List<OBJ>, input: CHANGE) {
        extractInputInnerValue(input)?.let { innerValue ->
            objects.forEach { operations.add(it, innerValue) }
        }
    }

    fun applyRemove(objects: List<OBJ>, input: CHANGE) {
        extractInputInnerValue(input)?.let { innerValue ->
            objects.forEach { operations.remove(it, innerValue) }
        }
    }
}


/**
 * Группа объектов, имеющих одно и то же значение
 */
data class ValueGroup<V, O>(
    val value: V,
    val objects: List<O>,
)

/**
 * Группирует объекты по значениям, которые в этих объектах хранятся
 *
 * @param[objects] список группируемых объектов
 * @param[valuesExtractor] функция получения значений из объекта
 */
fun <V, O> groupObjectsByValue(objects: Collection<O>, valuesExtractor: (O) -> List<V>): List<ValueGroup<V, O>> {
    return objects.asSequence()
        .flatMap { obj -> valuesExtractor(obj).map { it to obj } }
        .groupBy({ it.first }, { it.second })
        .map { (value, objList) -> ValueGroup(value, objList) }
}
