package ru.yandex.direct.grid.processing.service.inventori;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.inventori.GdIndoorReachRequest;
import ru.yandex.direct.grid.processing.model.inventori.GdOutdoorReachRequest;
import ru.yandex.direct.grid.processing.model.inventori.GdReachIndoorResult;
import ru.yandex.direct.grid.processing.model.inventori.GdReachMultiBudgetRequest;
import ru.yandex.direct.grid.processing.model.inventori.GdReachMultiBudgetsResult;
import ru.yandex.direct.grid.processing.model.inventori.GdReachOutdoorResult;
import ru.yandex.direct.grid.processing.model.inventori.GdReachRecommendationResult;
import ru.yandex.direct.grid.processing.model.inventori.GdReachRequest;
import ru.yandex.direct.grid.processing.model.inventori.GdReachResult;
import ru.yandex.direct.grid.processing.model.inventori.GdUacForecastResponse;
import ru.yandex.direct.grid.processing.model.inventori.GdUacReachRequest;
import ru.yandex.direct.grid.processing.model.inventori.GdUacRecommendationRequest;
import ru.yandex.direct.grid.processing.model.inventori.GdUacRecommendationResponse;
import ru.yandex.direct.grid.processing.processor.GraphQLRateLimit;


/**
 * Сервис для рассчета охвата аудитории
 **/
@GridGraphQLService
@ParametersAreNonnullByDefault
public class InventoriGraphQlService {
    private final GridInventoriService service;

    @Autowired
    public InventoriGraphQlService(GridInventoriService service) {
        this.service = service;
    }

    @GraphQLNonNull
    @GraphQLQuery(name = "reach")
    @GraphQLRateLimit(periodInSeconds = 300, maxRequests = 200) // Не более 200 запросов за 5 минут
    public GdReachResult reach(
            @GraphQLNonNull @GraphQLArgument(name = "input") GdReachRequest input,
            @GraphQLRootContext GridGraphQLContext context) {
        return service.getReach(input);
    }

    @GraphQLQuery(name = "reachOutdoor")
    public GdReachOutdoorResult getReachOutdoor(
            @GraphQLNonNull @GraphQLArgument(name = "input") GdOutdoorReachRequest input,
            @GraphQLRootContext GridGraphQLContext context) {
        return service.getOutdoorReach(input, context.getSubjectUser().getClientId());
    }

    @GraphQLQuery(name = "reachIndoor")
    public GdReachIndoorResult getReachIndoor(
            @GraphQLNonNull @GraphQLArgument(name = "input") GdIndoorReachRequest input,
            @GraphQLRootContext GridGraphQLContext context) {
        return service.getIndoorReach(input, context.getSubjectUser().getClientId());
    }

    @GraphQLNonNull
    @GraphQLQuery(name = "reachRecommendation")
    public GdReachRecommendationResult getReachRecommendation(
            @GraphQLNonNull @GraphQLArgument(name = "input") GdReachRequest input,
            @GraphQLRootContext GridGraphQLContext context) {
        return service.getReachRecommendation(input);
    }

    // todo удалить когда фронт переедет на reachTouchMultiBudgets
    @GraphQLNonNull
    @GraphQLQuery(name = "reachMultiBudgets")
    public GdReachMultiBudgetsResult getReachMultiBudgets(
            @GraphQLNonNull @GraphQLArgument(name = "input") GdReachMultiBudgetRequest input,
            @GraphQLRootContext GridGraphQLContext context) {
        User subjectUser = context.getSubjectUser();
        ClientId clientId = subjectUser.getClientId();

        return service.getReachMultiBudgets(input, clientId);
    }

    @GraphQLNonNull
    @GraphQLQuery(name = "reachTouchMultiBudgets")
    public GdReachMultiBudgetsResult getReachTouchMultiBudgets(
            @GraphQLNonNull @GraphQLArgument(name = "input") GdReachMultiBudgetRequest input,
            @GraphQLRootContext GridGraphQLContext context) {
        User subjectUser = context.getSubjectUser();
        ClientId clientId = subjectUser.getClientId();

        return service.getReachMultiBudgets(input, clientId);
    }

    @GraphQLQuery(name = "uacRecommendation")
    public GdUacRecommendationResponse getUacRecommendation(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdUacRecommendationRequest input) {
        return service.getRecommendation(context, input);
    }

    @GraphQLQuery(name = "uacReach")
    public GdReachResult getUacReach(
            @GraphQLNonNull @GraphQLArgument(name = "input") GdUacReachRequest input) {
        return service.getReach(input);
    }

    @GraphQLQuery(name = "uacForecast")
    public GdUacForecastResponse getUacForecast(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdUacRecommendationRequest input) {
        return service.getUacCampaignForecast(context, input);
    }
}
