package ru.yandex.direct.grid.processing.service.jsonsettings;

import java.util.function.Predicate;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.jayway.jsonpath.JsonPath;

import ru.yandex.direct.grid.model.jsonsettings.GdUpdateJsonSettingsUnion;
import ru.yandex.direct.grid.model.jsonsettings.IdType;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

@ParametersAreNonnullByDefault
public class JsonSettingsValidationUtils {

    public static Constraint<IdType, Defect> allowedIdType() {
        return Constraint.fromPredicate(type -> type == IdType.UID, invalidValue());
    }

    public static Validator<GdUpdateJsonSettingsUnion, Defect> getJsonSettingsUnionValidator() {
        return req -> {
            ModelItemValidationBuilder<GdUpdateJsonSettingsUnion> vb = ModelItemValidationBuilder.of(req);
            vb.item(GdUpdateJsonSettingsUnion.NEW_VALUE)
                    .check(validJsonValue());
            vb.item(GdUpdateJsonSettingsUnion.JSON_PATH)
                    .check(validJsonPath());

            return vb.getResult();
        };
    }

    public static Constraint<String, Defect> validJsonPath() {
        Predicate<String> pr = jsonPath -> {
            try {
                JsonPath.compile(jsonPath);
            } catch (Exception e) {
                return false;
            }
            return true;
        };
        return Constraint.fromPredicate(pr, invalidValue());
    }

    public static Constraint<Object, Defect> validJsonValue() {
        Predicate<Object> pr = obj -> {
            try {
                ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                ow.writeValueAsString(obj);
            } catch (Exception e) {
                return false;
            }
            return true;
        };
        return Constraint.fromPredicate(pr, invalidValue());
    }
}
