package ru.yandex.direct.grid.processing.service.landing;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLContext;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.client.GdClient;
import ru.yandex.direct.grid.processing.model.landing.GdAddBizLanding;
import ru.yandex.direct.grid.processing.model.landing.GdAddBizLandingPayload;
import ru.yandex.direct.grid.processing.model.landing.GdBizLanding;
import ru.yandex.direct.grid.processing.model.landing.GdGetBizLanding;
import ru.yandex.direct.grid.processing.model.landing.GdUpdateBizLanding;
import ru.yandex.direct.grid.processing.model.landing.GdUpdateBizLandingPayload;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class BizLandingGraphQLService {

    private final BizLandingDataService bizLandingDataService;

    @Autowired
    public BizLandingGraphQLService(BizLandingDataService bizLandingDataService) {
        this.bizLandingDataService = bizLandingDataService;
    }

    @GraphQLQuery(name = "bizLanding")
    public GdBizLanding getBizLanding(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLContext GdClient client,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdGetBizLanding input
    ) {
        var operatorUid = context.getOperator().getUid();
        return bizLandingDataService.getBizLanding(operatorUid, input);
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "updateBizLanding")
    public GdUpdateBizLandingPayload updateBizLanding(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdUpdateBizLanding input
    ) {
        var operatorUid = context.getOperator().getUid();

        return bizLandingDataService.updateBizLanding(operatorUid, input);
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "addBizLanding")
    public GdAddBizLandingPayload addBizLanding(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdAddBizLanding input
    ) {
        var operatorUid = context.getOperator().getUid();

        return bizLandingDataService.addBizLanding(operatorUid, input);
    }

}
