package ru.yandex.direct.grid.processing.service.landing

import org.springframework.stereotype.Service
import ru.yandex.direct.grid.processing.model.api.GdValidationResult
import ru.yandex.direct.grid.processing.model.landing.GdGetBizLanding
import ru.yandex.direct.grid.processing.service.validation.GridValidationResultConversionService
import ru.yandex.direct.grid.processing.service.validation.GridValidationService
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints.isNull
import ru.yandex.direct.validation.constraint.CommonConstraints.notNull
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

@Service
class GdBizLandingValidationService(
        private val gridValidationService: GridValidationService,
        private val gridValidationResultConversionService: GridValidationResultConversionService,
) {

    fun toGdValidationResult(vr: ValidationResult<*, Defect<*>?>): GdValidationResult? {
        return gridValidationResultConversionService.buildGridValidationResult(vr)
    }

    fun validateGetInput(request: GdGetBizLanding) {
        gridValidationService.applyValidator({ getGetInputValidator(it) }, request, false)
    }

    private fun getGetInputValidator(request: GdGetBizLanding): ValidationResult<GdGetBizLanding, Defect<*>?> {
        val vb = ModelItemValidationBuilder.of(request)
        vb.item(GdGetBizLanding.ID)
                .check(notNull(), When.isTrue(request.permalink == null))
                .check(isNull(), When.isFalse(request.permalink == null))
        vb.item(GdGetBizLanding.PERMALINK)
                .check(notNull(), When.isTrue(request.id == null))
                .check(isNull(), When.isFalse(request.id == null))
        return vb.result
    }

}
