package ru.yandex.direct.grid.processing.service.menuheader;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.client.GdMenuHeaderInfo;
import ru.yandex.direct.grid.processing.model.client.GdMenuItem;

/**
 * GraphQL-сервис, отдающий информацию об объектах меню, которые нужно отобразить в шапке.
 */
@GridGraphQLService
@ParametersAreNonnullByDefault
public class MenuHeaderGraphQlService {
    private final AllowedMenuItemsService allowedMenuItemsService;

    @Autowired
    public MenuHeaderGraphQlService(AllowedMenuItemsService allowedMenuItemsService) {
        this.allowedMenuItemsService = allowedMenuItemsService;
    }

    /**
     * GraphQL запрос. Получить информацию о кнопках, которые нужно отобразить в шапке.
     */
    @GraphQLNonNull
    @GraphQLQuery(name = "menuHeader")
    public GdMenuHeaderInfo menuHeader(@GraphQLRootContext GridGraphQLContext context) {
        Set<GdMenuItem> allowedItems = allowedMenuItemsService.getAllowedMenuItems(context.getOperator(),
                context.getSubjectUser().getClientId());

        return new GdMenuHeaderInfo()
                .withAllowedMenuItems(allowedItems);
    }
}
