package ru.yandex.direct.grid.processing.service.minuskeywordspack;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.GdGetMinusKeywordsPacks;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.GdGetMinusKeywordsPacksPayload;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.mutation.GdAddMinusKeywordsPacks;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.mutation.GdAddMinusKeywordsPacksPayload;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.mutation.GdDeleteMinusKeywordsPacks;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.mutation.GdDeleteMinusKeywordsPacksPayload;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.mutation.GdUpdateMinusKeywordsPacks;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.mutation.GdUpdateMinusKeywordsPacksPayload;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class MinusKeywordsPackGraphQlService {

    private final MinusKeywordsPackDataService minusKeywordsPackDataService;

    @Autowired
    public MinusKeywordsPackGraphQlService(MinusKeywordsPackDataService minusKeywordsPackDataService) {
        this.minusKeywordsPackDataService = minusKeywordsPackDataService;
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "addMinusKeywordsPacks", description = "Создание набора минус-фраз")
    public GdAddMinusKeywordsPacksPayload addMinusKeywordsPacks(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdAddMinusKeywordsPacks input) {
        return minusKeywordsPackDataService.addMinusKeywordsPacks(input, context.getSubjectUser().getClientId());
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "updateMinusKeywordsPacks", description = "Изменение набора минус-фраз")
    public GdUpdateMinusKeywordsPacksPayload updateMinusKeywordsPacks(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdUpdateMinusKeywordsPacks input) {
        return minusKeywordsPackDataService.updateMinusKeywordsPacks(input, context.getSubjectUser().getClientId());
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "deleteMinusKeywordsPacks", description = "Удаление набора минус-фраз")
    public GdDeleteMinusKeywordsPacksPayload deleteMinusKeywordsPacks(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdDeleteMinusKeywordsPacks input) {
        return minusKeywordsPackDataService.deleteMinusKeywordsPacks(input, context.getSubjectUser().getClientId());
    }

    @GraphQLNonNull
    @GraphQLQuery(name = "getLibraryMinusKeywordsPacks", description = "Получение библиотечных наборов минус-фраз")
    public GdGetMinusKeywordsPacksPayload getLibraryMinusKeywordsPacks(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdGetMinusKeywordsPacks input) {
        return minusKeywordsPackDataService.getLibraryMinusKeywordsPacks(input, context.getSubjectUser().getClientId());
    }
}
