package ru.yandex.direct.grid.processing.service.minuskeywordspack.converter;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.core.entity.minuskeywordspack.container.AddedMinusKeywordsPackInfo;
import ru.yandex.direct.core.entity.minuskeywordspack.container.UpdatedMinusKeywordsPackInfo;
import ru.yandex.direct.core.entity.minuskeywordspack.model.MinusKeywordsPack;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.processing.model.banner.mutation.GetMinusKeywordsPacksCacheFilterData;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.GdGetMinusKeywordsPacks;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.GdGetMinusKeywordsPacksItem;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.mutation.GdAddMinusKeywordsPacks;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.mutation.GdAddMinusKeywordsPacksItem;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.mutation.GdAddMinusKeywordsPacksPayloadItem;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.mutation.GdUpdateMinusKeywordsPacks;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.mutation.GdUpdateMinusKeywordsPacksItem;
import ru.yandex.direct.grid.processing.model.minuskeywordspack.mutation.GdUpdateMinusKeywordsPacksPayloadItem;
import ru.yandex.direct.grid.processing.service.minuskeywordspack.container.GetMinusKeywordsPacksCacheRecordInfo;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class MinusKeywordsPackDataConverter {

    public static List<MinusKeywordsPack> toCoreMinusKeywordsPacks(GdAddMinusKeywordsPacks addMinusKeywordsPacks) {
        return mapList(addMinusKeywordsPacks.getAddItems(), MinusKeywordsPackDataConverter::toCoreMinusKeywordsPack);
    }

    public static MinusKeywordsPack toCoreMinusKeywordsPack(GdAddMinusKeywordsPacksItem addMinusKeywordsPacksItem) {
        return new MinusKeywordsPack()
                .withName(addMinusKeywordsPacksItem.getName())
                .withMinusKeywords(addMinusKeywordsPacksItem.getMinusKeywords());
    }

    public static GdAddMinusKeywordsPacksPayloadItem toGdAddMinusKeywordsPacksPayloadItem(
            AddedMinusKeywordsPackInfo addedMinusKeywordsPackInfo) {
        return new GdAddMinusKeywordsPacksPayloadItem()
                .withId(addedMinusKeywordsPackInfo.getId())
                .withName(addedMinusKeywordsPackInfo.getName())
                .withMinusKeywords(addedMinusKeywordsPackInfo.getMinusKeywords());

    }

    public static List<ModelChanges<MinusKeywordsPack>> toCoreMinusKeywordsPackChanges(
            GdUpdateMinusKeywordsPacks updateMinusKeywordsPacks) {
        return mapList(updateMinusKeywordsPacks.getUpdateItems(),
                MinusKeywordsPackDataConverter::toCoreMinusKeywordsPackChanges);
    }

    public static ModelChanges<MinusKeywordsPack> toCoreMinusKeywordsPackChanges(
            GdUpdateMinusKeywordsPacksItem updateMinusKeywordsPacksItem) {
        return new ModelChanges<>(updateMinusKeywordsPacksItem.getId(), MinusKeywordsPack.class)
                .processNotNull(updateMinusKeywordsPacksItem.getName(), MinusKeywordsPack.NAME)
                .processNotNull(updateMinusKeywordsPacksItem.getMinusKeywords(), MinusKeywordsPack.MINUS_KEYWORDS);
    }

    public static GdUpdateMinusKeywordsPacksPayloadItem toGdUpdateMinusKeywordsPacksPayloadItem(
            UpdatedMinusKeywordsPackInfo updatedMinusKeywordsPackInfo) {
        return new GdUpdateMinusKeywordsPacksPayloadItem()
                .withId(updatedMinusKeywordsPackInfo.getId())
                .withName(updatedMinusKeywordsPackInfo.getName())
                .withMinusKeywords(updatedMinusKeywordsPackInfo.getMinusKeywords());

    }

    public static List<GdGetMinusKeywordsPacksItem> toGdGetMinusKeywordsPacksItemList(
            List<Pair<MinusKeywordsPack, Long>> packsWithLinksCount) {
        return packsWithLinksCount.stream()
                .map(pair -> new GdGetMinusKeywordsPacksItem()
                        .withId(pair.getLeft().getId())
                        .withName(pair.getLeft().getName())
                        .withMinusKeywords(pair.getLeft().getMinusKeywords())
                        .withLinkedAdGroupsCount(pair.getRight()))
                .collect(Collectors.toList());

    }

    public static GetMinusKeywordsPacksCacheRecordInfo getCacheRecordInfo(ClientId clientId,
                                                                          GdGetMinusKeywordsPacks input) {
        return new GetMinusKeywordsPacksCacheRecordInfo(clientId.asLong(), input.getCacheKey(),
                new GetMinusKeywordsPacksCacheFilterData()
                        .withPackIdIn(input.getPackIdIn())
        );
    }
}
