package ru.yandex.direct.grid.processing.service.moderation;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiag;
import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiagType;
import ru.yandex.direct.core.entity.moderationdiag.service.ModerationDiagService;
import ru.yandex.direct.grid.model.moderation.GdModerationDiag;
import ru.yandex.direct.grid.model.moderation.GdModerationReasonType;
import ru.yandex.direct.grid.model.utils.GridModerationUtils;

@Service
public class ModerationDataService {
    private final ModerationDiagService moderationDiagService;

    @Autowired
    public ModerationDataService(ModerationDiagService moderationDiagService) {
        this.moderationDiagService = moderationDiagService;
    }

    public List<GdModerationDiag> getModerationDiags(Map<GdModerationReasonType, Set<Long>> reasonIdsByType) {
        return EntryStream.of(reasonIdsByType)
                .mapKeys(GridModerationUtils::fromGdModerationReasonType)
                .flatMapKeyValue(this::toGdModerationDiags)
                .toList();
    }

    private StreamEx<GdModerationDiag> toGdModerationDiags(ModerationDiagType diagType, Collection<Long> diagIds) {
        Map<Long, ModerationDiag> diagsById = moderationDiagService.get(diagType);
        return StreamEx.of(diagIds)
                .map(diagsById::get)
                .nonNull()
                .map(diag -> new GdModerationDiag()
                        .withId(diag.getId())
                        .withType(GridModerationUtils.toGdModerationReasonType(diagType))
                        .withShortText(diag.getShortText())
                        .withFullText(diag.getFullText())
                        .withAllowFirstAid(diag.getAllowFirstAid())
                        .withStrongReason(diag.getStrongReason())
                        .withUnbanIsProhibited(diag.getUnbanIsProhibited())
                        .withToken(diag.getToken()));
    }
}
