package ru.yandex.direct.grid.processing.service.moderation;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.grid.model.moderation.GdModerationDiag;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.model.moderation.GdModerationDiagsContainer;

import static ru.yandex.direct.validation.result.PathHelper.field;
import static ru.yandex.direct.validation.result.PathHelper.path;

/**
 * Сервис, возвращающий данные о причинах отклонения модерацией
 */
@GridGraphQLService
@ParametersAreNonnullByDefault
public class ModerationGraphQlService {
    private final ModerationDataService moderationDataService;
    private final ModerationValidationService moderationValidationService;

    @Autowired
    public ModerationGraphQlService(ModerationDataService moderationDataService,
                                    ModerationValidationService moderationValidationService) {
        this.moderationDataService = moderationDataService;
        this.moderationValidationService = moderationValidationService;
    }

    /**
     * GraphQL запрос. Получает подробные данные о причинах отклонения переданных типов
     * с переданными идентификаторами
     */
    @GraphQLNonNull
    @GraphQLQuery(name = "moderationDiags")
    public List<GdModerationDiag> getModerationDiags(@GraphQLNonNull @GraphQLArgument(name = "input") GdModerationDiagsContainer input) {
        var reasonIdsByType = input.getReasonIdsByType();
        moderationValidationService.validateRejectReasons(reasonIdsByType,
                path(field(GdModerationDiagsContainer.REASON_IDS_BY_TYPE)));
        return moderationDataService.getModerationDiags(reasonIdsByType);
    }
}
