package ru.yandex.direct.grid.processing.service.moderation;

import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.grid.model.moderation.GdModerationReasonType;
import ru.yandex.direct.grid.processing.service.validation.GridValidationService;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.Path;

import static ru.yandex.direct.grid.processing.service.validation.GridValidationService.IDS_COLLECTION_VALIDATOR;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Service
@ParametersAreNonnullByDefault
public class ModerationValidationService {
    private final GridValidationService gridValidationService;

    private static final Validator<Map<GdModerationReasonType, Set<Long>>, Defect> REJECT_REASONS_VALIDATOR =
            reasonIdsByType -> {
                ItemValidationBuilder<Map<GdModerationReasonType, Set<Long>>, Defect> vb =
                        ItemValidationBuilder.of(reasonIdsByType);
                EntryStream.of(reasonIdsByType)
                        .forKeyValue((type, reasonIds) ->
                                vb.item(reasonIds, type.name())
                                        .check(notNull())
                                        .checkBy(IDS_COLLECTION_VALIDATOR, When.notNull()));
                return vb.getResult();
            };

    @Autowired
    public ModerationValidationService(GridValidationService gridValidationService) {
        this.gridValidationService = gridValidationService;
    }

    public void validateRejectReasons(Map<GdModerationReasonType, Set<Long>> rejectReasons, Path pathPrefix) {
        gridValidationService.applyValidator(REJECT_REASONS_VALIDATOR, rejectReasons, false, pathPrefix);
    }
}
