package ru.yandex.direct.grid.processing.service.music;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.audio.GdAudioGenre;
import ru.yandex.direct.grid.processing.model.audio.GdAudioGenreContext;
import ru.yandex.direct.grid.processing.model.audio.GdAudioGenresContainer;

/**
 * Сервис, возвращающий справочник аудио жанров
 **/

@GridGraphQLService
@ParametersAreNonnullByDefault
public class AudioGenreGraphQlService {
    private final AudioGenreService audioGenreService;

    @Autowired
    public AudioGenreGraphQlService(AudioGenreService audioGenreService) {
        this.audioGenreService = audioGenreService;
    }

    /**
     * GraphQL подзапрос. Получает справочник жанров аудио
     *
     * @param context контекст
     * @param input   параметры фильтра и вывода
     */
    @GraphQLNonNull
    @GraphQLQuery(name = "audioGenres")
    public GdAudioGenreContext getAudioGenres(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdAudioGenresContainer input) {
        List<GdAudioGenre> gdAudioGenres = audioGenreService.getAudioGenres();
        return new GdAudioGenreContext()
                .withRowset(gdAudioGenres)
                .withTotalCount(gdAudioGenres.size());
    }
}
