package ru.yandex.direct.grid.processing.service.music;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.music.AudioGenreRepository;
import ru.yandex.direct.grid.processing.model.audio.GdAudioGenre;

import static java.util.stream.Collectors.toList;

@Service
public class AudioGenreService {
    private final AudioGenreRepository audioGenreRepository;

    @Autowired
    public AudioGenreService(AudioGenreRepository audioGenreRepository) {
        this.audioGenreRepository = audioGenreRepository;
    }

    public List<GdAudioGenre> getAudioGenres() {
        return audioGenreRepository.getAll().values().stream()
                .map(audioGenre -> new GdAudioGenre()
                        .withId(audioGenre.getId())
                        .withParentId(audioGenre.getParentId())
                        .withName(audioGenre.getName())
                        .withTankerNameKey(audioGenre.getTankerNameKey())
                        .withTankerDescriptionKey(audioGenre.getTankerDescriptionKey())
                )
                .collect(toList());
    }

}
