package ru.yandex.direct.grid.processing.service.offer.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.grid.core.entity.offer.model.GdiOffer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelWithId;

import static ru.yandex.direct.utils.CommonUtils.min;

@ParametersAreNonnullByDefault
public abstract class OfferFilterBuilder<M extends ModelWithId, T> {
    protected abstract int maxItemCount();

    protected abstract Collection<T> getConditions();

    protected abstract List<String> getItems(T condition);

    protected abstract void setItems(@Nullable T condition, List<String> items);

    public abstract ModelChanges<M> toModelChanges();

    public OfferFilterBuilder<M, T> filterOffers(Collection<GdiOffer> offers) {
        // сначала будем дозаполнять существующие подходящие условия, по порядку
        var conditions = new ArrayDeque<>(getConditions());

        // пропускаем уже отфильтрованные товары
        var filteredUrls = StreamEx.of(conditions)
                .flatCollection(this::getItems)
                .toSet();
        var urlsToFilter = StreamEx.of(offers)
                .map(GdiOffer::getUrl)
                .remove(filteredUrls::contains)
                .distinct()
                .toList();

        int fromIndex = 0;
        while (fromIndex < urlsToFilter.size()) {
            var urls = new ArrayList<String>();

            var condition = conditions.poll();
            if (condition != null) {
                urls.addAll(getItems(condition));
            }

            int freeItemCount = maxItemCount() - urls.size();
            var urlsToAdd = urlsToFilter.subList(fromIndex, min(fromIndex + freeItemCount, urlsToFilter.size()));
            urls.addAll(urlsToAdd);
            fromIndex += urlsToAdd.size();

            setItems(condition, urls);
        }

        return this;
    }
}
