package ru.yandex.direct.grid.processing.service.offer.util;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicFeedAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicFeedRule;
import ru.yandex.direct.core.entity.dynamictextadtarget.utils.DynamicTextAdTargetHashUtils;
import ru.yandex.direct.core.entity.performancefilter.model.Operator;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchema;
import ru.yandex.direct.model.ModelChanges;

@SuppressWarnings("rawtypes")
@ParametersAreNonnullByDefault
public class OfferFilterDynamicFeedAdTargetBuilder extends OfferFilterFeedConditionsBuilder<DynamicFeedAdTarget, DynamicFeedRule> {
    private final long id;

    public OfferFilterDynamicFeedAdTargetBuilder(FilterSchema filterSchema, DynamicFeedAdTarget dynamicFeedAdTarget) {
        super(filterSchema, dynamicFeedAdTarget.getCondition());
        this.id = dynamicFeedAdTarget.getId();
    }

    @Override
    protected DynamicFeedRule createCondition(String fieldName, Operator operator, String stringValue) {
        return new DynamicFeedRule(fieldName, operator, stringValue);
    }

    @Override
    public ModelChanges<DynamicFeedAdTarget> toModelChanges() {
        return new ModelChanges<>(id, DynamicFeedAdTarget.class)
                .process(conditions, DynamicFeedAdTarget.CONDITION)
                .process(conditions, DynamicFeedAdTarget.CONDITION_HASH,
                        DynamicTextAdTargetHashUtils::getHashForDynamicFeedRules);
    }
}
