package ru.yandex.direct.grid.processing.service.offer.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicTextAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRule;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRuleKind;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRuleType;
import ru.yandex.direct.core.entity.dynamictextadtarget.repository.DynamicTextAdTargetMapping;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.DynamicTextAdTargetConstants;
import ru.yandex.direct.core.entity.dynamictextadtarget.utils.DynamicTextAdTargetHashUtils;
import ru.yandex.direct.model.ModelChanges;

@ParametersAreNonnullByDefault
public class OfferFilterDynamicTextAdTargetBuilder extends OfferFilterBuilder<DynamicTextAdTarget, WebpageRule> {
    private final long id;
    private final List<WebpageRule> conditions;

    public OfferFilterDynamicTextAdTargetBuilder(DynamicTextAdTarget dynamicTextAdTarget) {
        this.id = dynamicTextAdTarget.getId();
        this.conditions = new ArrayList<>(dynamicTextAdTarget.getCondition());
    }

    @Override
    protected int maxItemCount() {
        return DynamicTextAdTargetConstants.MAX_ARGUMENTS;
    }

    @Override
    protected Collection<WebpageRule> getConditions() {
        return StreamEx.of(conditions)
                .filterBy(WebpageRule::getType, WebpageRuleType.URL_PRODLIST)
                .filterBy(WebpageRule::getKind, WebpageRuleKind.NOT_EQUALS)
                .toList();
    }

    @Override
    protected List<String> getItems(WebpageRule condition) {
        return condition.getValue();
    }

    @Override
    protected void setItems(@Nullable WebpageRule condition, List<String> items) {
        if (condition != null) {
            condition.setValue(items);
        } else {
            if (DynamicTextAdTargetMapping.isAllPageCondition(conditions)) {
                conditions.clear();
            }
            conditions.add(new WebpageRule()
                    .withType(WebpageRuleType.URL_PRODLIST)
                    .withKind(WebpageRuleKind.NOT_EQUALS)
                    .withValue(items));
        }
    }

    @Override
    public ModelChanges<DynamicTextAdTarget> toModelChanges() {
        return new ModelChanges<>(id, DynamicTextAdTarget.class)
                .process(conditions, DynamicTextAdTarget.CONDITION)
                .process(conditions, DynamicTextAdTarget.CONDITION_HASH, DynamicTextAdTargetHashUtils::getHash)
                .process(conditions, DynamicTextAdTarget.CONDITION_UNIQ_HASH,
                        DynamicTextAdTargetHashUtils::getUniqHash);
    }
}
