package ru.yandex.direct.grid.processing.service.offer.util;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.performancefilter.model.Operator;
import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilter;
import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilterCondition;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchema;
import ru.yandex.direct.model.ModelChanges;

@SuppressWarnings("rawtypes")
@ParametersAreNonnullByDefault
public class OfferFilterPerformanceFilterBuilder extends OfferFilterFeedConditionsBuilder<PerformanceFilter, PerformanceFilterCondition> {
    private final long id;

    public OfferFilterPerformanceFilterBuilder(FilterSchema filterSchema, PerformanceFilter filter) {
        super(filterSchema, filter.getConditions());
        this.id = filter.getId();
    }

    @Override
    protected PerformanceFilterCondition createCondition(String fieldName, Operator operator, String stringValue) {
        return new PerformanceFilterCondition(fieldName, operator, stringValue);
    }

    @Override
    public ModelChanges<PerformanceFilter> toModelChanges() {
        return ModelChanges.build(id, PerformanceFilter.class, PerformanceFilter.CONDITIONS, conditions);
    }
}
