package ru.yandex.direct.grid.processing.service.offlinereport;

import java.util.List;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.offlinereport.model.OfflineReport;
import ru.yandex.direct.core.entity.offlinereport.model.OfflineReportType;
import ru.yandex.direct.core.entity.offlinereport.service.OfflineReportService;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.grid.processing.model.offlinereport.GdOfflineReport;
import ru.yandex.direct.grid.processing.model.offlinereport.GdOfflineReportResult;
import ru.yandex.direct.grid.processing.model.offlinereport.GdOfflineReportResultRequest;
import ru.yandex.direct.grid.processing.model.offlinereport.GdOfflineReportWithDailyIntervalRequest;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Сервис для работы с оффлайн отчётами
 **/
@Service
public class OfflineReportGridService {
    public static final OfflineReportType DEFAULT_REPORT_TYPE = OfflineReportType.DOMAINS;

    private final OfflineReportService service;
    private final OfflineReportValidationService validationService;

    public OfflineReportGridService(OfflineReportService service,
                                    OfflineReportValidationService validationService) {
        this.service = service;
        this.validationService = validationService;
    }

    public GdOfflineReportResult getOfflineReportList(User operator, OfflineReportType offlineReportType) {
        return new GdOfflineReportResult().withList(
                convertOfflineReportListToGd(service.getAgencyOfflineReports(operator, offlineReportType)));
    }

    public GdOfflineReport createOfflineReportWithMonthlyInterval(GdOfflineReportResultRequest input, User operator,
                                                                  User agencyUser) {
        validationService.validateOfflineReportWithMonthlyIntervalRequest(input);
        return convertOfflineReportToGd(service.createOfflineReportWithMonthlyInterval(operator, agencyUser,
                input.getReportType(), input.getMonthFrom(), input.getMonthTo()));
    }

    public GdOfflineReport createOfflineReportWithDailyInterval(GdOfflineReportWithDailyIntervalRequest input,
                                                                User operator, User agencyUser) {
        validationService.validateOfflineReportWithDailyIntervalRequest(input);
        return convertOfflineReportToGd(service.createOfflineReportWithDailyInterval(operator, agencyUser,
                input.getReportType(), input.getDateFrom(), input.getDateTo()));
    }

    private List<GdOfflineReport> convertOfflineReportListToGd(List<OfflineReport> list) {
        return mapList(list, this::convertOfflineReportToGd);
    }

    private GdOfflineReport convertOfflineReportToGd(OfflineReport model) {
        return new GdOfflineReport()
                .withReportId(model.getReportId())
                .withUid(model.getUid())
                .withReportState(model.getReportState())
                .withScheduledAt(model.getScheduledAt())
                .withReportType(model.getReportType())
                .withReportUrl(model.getReportUrl())
                .withArgs(model.getArgs());
    }
}
