package ru.yandex.direct.grid.processing.service.operator;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.grid.model.campaign.GdiBaseCampaign;
import ru.yandex.direct.grid.processing.model.campaign.GdWallet;
import ru.yandex.direct.grid.processing.model.client.GdClientFeatures;
import ru.yandex.direct.grid.processing.model.client.GdClientInfo;

public class CalcClientAccessContainer {
    private User subjectUser;
    private GdClientInfo gdClientInfo;
    private Supplier<Collection<GdiBaseCampaign>> gdiNonWalletCampaigns;
    private Supplier<Map<Long, GdWallet>> gdWalletsMap;
    private Supplier<Optional<GdWallet>> firstWallet;
    private Supplier<GdClientFeatures> gdClientFeatures;

    public CalcClientAccessContainer(User subjectUser,
                                     GdClientInfo gdClientInfo,
                                     Supplier<Collection<GdiBaseCampaign>> gdiNonWalletCampaigns,
                                     Supplier<Map<Long, GdWallet>> gdWalletsMap,
                                     Supplier<Optional<GdWallet>> firstWallet,
                                     Supplier<GdClientFeatures> gdClientFeatures) {
        this.subjectUser = subjectUser;
        this.gdClientInfo = gdClientInfo;
        this.gdiNonWalletCampaigns = gdiNonWalletCampaigns;
        this.gdWalletsMap = gdWalletsMap;
        this.firstWallet = firstWallet;
        this.gdClientFeatures = gdClientFeatures;
    }

    public User getSubjectUser() {
        return subjectUser;
    }

    public GdClientInfo getGdClientInfo() {
        return gdClientInfo;
    }

    public Collection<GdiBaseCampaign> getClientNonWalletCampaigns() {
        return gdiNonWalletCampaigns.get();
    }

    public Map<Long, GdWallet> getClientWallets() {
        return gdWalletsMap.get();
    }

    @Nullable
    public GdWallet getFirstWallet() {
        return firstWallet.get().orElse(null);
    }

    public GdClientFeatures getGdClientFeatures() {
        return gdClientFeatures.get();
    }
}
