package ru.yandex.direct.grid.processing.service.operator;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.grid.processing.model.client.GdCoreFeatureWithDescription;
import ru.yandex.direct.grid.processing.model.client.GdOperatorFeatures;
import ru.yandex.direct.rbac.RbacRole;

@ParametersAreNonnullByDefault
class OperatorConverter {
    private OperatorConverter() {
    }

    static GdOperatorFeatures toGdOperatorFeatures(Set<String> availableFeatures, RbacRole role,
                                                   Set<GdCoreFeatureWithDescription> coreFeaturesWithDescription) {
        boolean isInternalAdRole = (role == RbacRole.INTERNAL_AD_ADMIN ||
                role == RbacRole.INTERNAL_AD_MANAGER ||
                role == RbacRole.INTERNAL_AD_SUPERREADER);

        return new GdOperatorFeatures()
                .withIsGridEnabled(availableFeatures.contains(FeatureName.GRID.getName()))
                .withIsBannerUpdateAllowed(availableFeatures.contains(FeatureName.BANNER_UPDATE_IN_JAVA_FOR_DNA.getName()))
                .withIsCpmBannerUpdateAllowed(availableFeatures.contains(FeatureName.CPM_BANNER_UPDATE_IN_JAVA_FOR_DNA.getName()))
                .withIsRmpBannersUpdateAllowed(availableFeatures.contains(FeatureName.RMP_BANNER_UPDATE_IN_JAVA_FOR_DNA.getName()))
                .withIsRmpGroupsUpdateAllowed(availableFeatures.contains(FeatureName.RMP_GROUPS_EDIT_FOR_DNA.getName()))
                .withIsAdsMassEditAllowed(availableFeatures.contains(FeatureName.ADS_MASS_EDIT_FOR_DNA.getName()))
                .withIsCpmAdGroupUpdateAllowed(availableFeatures.contains(FeatureName.CPM_ADGROUP_UPDATE_IN_JAVA_FOR_DNA.getName()))
                .withIsPerformanceAdEditAllowed(availableFeatures.contains(FeatureName.PERFORMANCE_AD_EDIT_ALLOWED_IN_DNA.getName()))
                .withIsBannerAimingAllowed(availableFeatures.contains(FeatureName.BANNER_AIMING_ALLOWED.getName()))
                .withIsBannerAimingCpmAllowed(availableFeatures.contains(FeatureName.BANNER_AIMING_CPM_ALLOWED.getName()))
                .withIsBannerAimingCpmYndxFrontpageAllowed(availableFeatures.contains(FeatureName.BANNER_AIMING_CPM_YNDX_FRONTPAGE_ALLOWED.getName()))
                .withUcDesignForDnaEditEnabled(availableFeatures.contains(FeatureName.UC_DESIGN_FOR_DNA_EDIT_ENABLED.getName()))
                .withUcDesignForDnaGridEnabled(availableFeatures.contains(FeatureName.UC_DESIGN_FOR_DNA_GRID_ENABLED.getName()))
                .withIsUserProfilePageAllowed(availableFeatures.contains(FeatureName.USER_PROFILE_PAGE_ALLOWED.getName()))
                .withEnablePreloadAssets(availableFeatures.contains(FeatureName.ENABLE_PRELOAD_ASSETS.getName()))
                .withEnablePrefetchAssets(availableFeatures.contains(FeatureName.ENABLE_PREFETCH_ASSETS.getName()))
                .withEnableLongTermCaching(availableFeatures.contains(FeatureName.ENABLE_LONG_TERM_CACHING.getName()))
                .withIsRetargetingGridEnabled(!isInternalAdRole
                        && availableFeatures.contains(FeatureName.SHOW_RETARGETING_GRID.getName()))
                .withIsAggregatedStatusAllowed(availableFeatures.contains(FeatureName.SHOW_AGGREGATED_STATUS.getName()))
                .withIsAggregatedStatusDebugAllowed(availableFeatures.contains(FeatureName.SHOW_AGGREGATED_STATUS_DEBUG.getName()))
                .withIsAggregatedStatusOpenBetaAllowed(availableFeatures.contains(FeatureName.SHOW_AGGREGATED_STATUS_OPEN_BETA.getName()))
                .withIsOldTextSmartEditHidden(availableFeatures.contains(FeatureName.HIDE_OLD_TEXT_SMART_EDIT_FOR_DNA.getName()))
                .withIsServiceWorkerAllowed(availableFeatures.contains((FeatureName.SERVICE_WORKER_ALLOWED.getName())))
                .withIsVideoGroupsEditAllowed(availableFeatures.contains(FeatureName.CPM_VIDEO_GROUPS_EDIT_FOR_DNA.getName()))
                .withIsAudioGroupsEditAllowed(availableFeatures.contains(FeatureName.CPM_AUDIO_GROUPS_EDIT_FOR_DNA.getName()))
                .withIsOutdoorGroupsEditAllowed(availableFeatures.contains(FeatureName.CPM_OUTDOOR_GROUPS_EDIT_FOR_DNA.getName()))
                .withIsIndoorGroupsEditAllowed(availableFeatures.contains(FeatureName.CPM_INDOOR_GROUPS_EDIT_FOR_DNA.getName()))
                .withIsGeoproductGroupsEditAllowed(availableFeatures.contains(FeatureName.CPM_GEOPRODUCT_GROUPS_EDIT_FOR_DNA.getName()))
                .withIsWebvisorEnabledForDna(availableFeatures.contains(FeatureName.WEBVISOR_ENABLED_FOR_DNA.getName()))
                .withIsMcBannerDnaEnabled(availableFeatures.contains(FeatureName.MCBANNER_DNA.getName()))
                .withIsMcBannerCampaignDnaEnabled(availableFeatures.contains(FeatureName.MCBANNER_CAMPAIGN_DNA.getName()))
                .withIsTargetTagsAllowed(availableFeatures.contains(FeatureName.TARGET_TAGS_ALLOWED.getName()))
                .withIsKeywordsEditOnBannersPageAllowed(availableFeatures.contains(FeatureName.KEYWORDS_EDIT_ON_BANNERS_PAGE_ALLOWED_FOR_DNA.getName()))
                .withIsPerformanceCampaignsEditAllowed(availableFeatures.contains(FeatureName.PERFORMANCE_CAMPAINGS_EDIT_ALLOWED_IN_DNA.getName()))
                .withIsDynamicCampaignsGroupsAndAdsEditAllowed(availableFeatures.contains(FeatureName.DYNAMIC_CAMPAIGNS_GROUPS_AND_ADS_EDIT_ALLOWED_IN_DNA.getName()))
                .withIsGoalsOnlyWithCampaignCountersUsed(availableFeatures.contains(FeatureName.GOALS_ONLY_WITH_CAMPAIGN_COUNTERS_USED.getName()))
                .withIsDefaultAutobudgetAvgCpaEnabled(availableFeatures.contains(FeatureName.DEFAULT_AUTOBUDGET_AVG_CPA.getName()))
                .withIsDefaultAutobudgetAvgClickWithWeekBudgetEnabled(availableFeatures.contains(FeatureName.DEFAULT_AUTOBUDGET_AVG_CLICK_WITH_WEEK_BUDGET.getName()))
                .withIsDefaultAutobudgetRoiEnabled(availableFeatures.contains(FeatureName.DEFAULT_AUTOBUDGET_ROI.getName()))
                .withIsOldShowCampsHidden(availableFeatures.contains(FeatureName.HIDE_OLD_SHOW_CAMPS_FOR_DNA.getName()))
                .withIsShowCampLinkByCellHoverEnabledForDna(availableFeatures.contains(FeatureName.SHOW_CAMP_LINK_BY_CELL_HOVER_ENABLED_FOR_DNA.getName()))
                .withIsShowCampLinkInPopupEnabledForDna(availableFeatures.contains(FeatureName.SHOW_CAMP_LINK_IN_POPUP_ENABLED_FOR_DNA.getName()))
                .withIsShowCampLinkInGridCellEnabledForDna(availableFeatures.contains(FeatureName.SHOW_CAMP_LINK_IN_GRID_CELL_ENABLED_FOR_DNA.getName()))
                .withIsShowCampLinkByNameClickEnabledForDna(availableFeatures.contains(FeatureName.SHOW_CAMP_LINK_BY_NAME_CLICK_ENABLED_FOR_DNA.getName()))
                .withIsBulkOpsCampaignsEditOrganizationEnabled(availableFeatures.contains(FeatureName.BULK_OPS_CAMPAIGNS_EDIT_ORGANIZATION.getName()))
                .withIsBulkOpsCampaignsEditStrategiesEnabled(availableFeatures.contains(FeatureName.BULK_OPS_CAMPAIGNS_EDIT_STRATEGIES.getName()))
                .withIsBulkOpsCampaignsEditDayBudgetEnabled(availableFeatures.contains(FeatureName.BULK_OPS_CAMPAIGNS_EDIT_DAY_BUDGET.getName()))
                .withIsFilterShortcutsEnabled(availableFeatures.contains(FeatureName.YDB_FILTER_SHORTCUTS_ENABLED.getName()))
                .withIsFilterShortcutsForCampaignEnabled(availableFeatures.contains(FeatureName.YDB_FILTER_SHORTCUTS_FOR_CAMPAIGN_ENABLED.getName()))
                .withIsShowDnaByDefaultEnabled(availableFeatures.contains(FeatureName.SHOW_DNA_BY_DEFAULT.getName()))
                .withIsCampaignCreationStepsEnabledForDna(availableFeatures.contains(FeatureName.CAMPAIGN_CREATION_STEPS_ENABLED_FOR_DNA.getName()))
                .withIsShowSidebarForAllEnabledForDna(availableFeatures.contains(FeatureName.SHOW_SIDEBAR_FOR_ALL_FOR_DNA.getName()))
                .withIsSuggestGeneratedGroupPhrasesForOperator(availableFeatures.contains(FeatureName.SUGGEST_GENERATED_GROUP_PHRASES_FOR_OPERATOR.getName()))
                .withIsSuggestGeneratedTitleAndSnippetForOperator(availableFeatures.contains(FeatureName.SUGGEST_GENERATED_TITLE_AND_SNIPPET_FOR_OPERATOR.getName()))
                .withIsSuggestGeneratedPhrasesBySnippetForOperator(availableFeatures.contains(FeatureName.SUGGEST_GENERATED_PHRASES_BY_SNIPPET_FOR_OPERATOR.getName()))
                .withIsSuggestGeneratedImagesForOperator(availableFeatures.contains(FeatureName.SUGGEST_GENERATED_IMAGES_FOR_OPERATOR.getName()))
                .withIsSuggestGeneratedSitelinksForOperator(availableFeatures.contains(FeatureName.SUGGEST_GENERATED_SITELINKS_FOR_OPERATOR.getName()))
                .withIsSuggestGeneratedRegionsForOperator(availableFeatures.contains(FeatureName.SUGGEST_GENERATED_REGIONS_FOR_OPERATOR.getName()))
                .withIsLoadingDnaScriptsBeforeOldInterfaceScriptsEnabled(availableFeatures.contains(FeatureName.LOADING_DNA_SCRIPTS_BEFORE_OLD_INTERFACE_SCRIPTS_ENABLED.getName()))
                .withIsSpellerOnEditAdEnabled(availableFeatures.contains(FeatureName.ENABLE_SPELLER_ON_AD_EDIT.getName()))
                .withIsInterClientCampaignCopyAllowed(availableFeatures.contains(FeatureName.INTERCLIENT_CAMPAIGN_COPY_ALLOWED.getName()))
                .withIsHoverableMenuEnabled(availableFeatures.contains(FeatureName.ENABLE_HOVERABLE_MENU.getName()))
                .withIsInternalLinksInSameWindowEnabled(availableFeatures.contains(FeatureName.ENABLE_INTERNAL_LINKS_IN_SAME_WINDOW.getName()))
                .withAvailableOperatorCoreFeatures(coreFeaturesWithDescription)
                .withIsSetCampaignDisallowedPageIdsEnabled(availableFeatures.contains(FeatureName.SET_CAMPAIGN_DISALLOWED_PAGE_IDS.getName()))
                .withIsBrandLiftCpmYndxFrontpageAllowed(availableFeatures.contains(FeatureName.BRAND_LIFT_HIDDEN.getName()))
                ;
    }

}
