package ru.yandex.direct.grid.processing.service.operator;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLContext;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.client.GdAvailableFields;
import ru.yandex.direct.grid.processing.model.client.GdFeedbackRateLaterPayload;
import ru.yandex.direct.grid.processing.model.client.GdOperatorAccess;
import ru.yandex.direct.grid.processing.model.client.GdOperatorInfo;

/**
 * Сервис, отдающий информацию об операторе, выполняющем запрос
 */
@GridGraphQLService
@ParametersAreNonnullByDefault
public class OperatorGraphQlService {
    private final OperatorDataService operatorDataService;

    @Autowired
    public OperatorGraphQlService(OperatorDataService operatorDataService) {
        this.operatorDataService = operatorDataService;
    }

    /**
     * GraphQL запрос. Получить данные об операторе, выполняющем запрос
     */
    @GraphQLNonNull
    @GraphQLQuery(name = "operator")
    public GdOperatorInfo getOperator(@GraphQLRootContext GridGraphQLContext context) {
        return operatorDataService.getOperatorInfo(context.getOperator());
    }

    /**
     * GraphQL запрос. Получить данные о разрешенных для оператора полях.
     * Удалится в https://st.yandex-team.ru/DIRECT-142815
     */
    @Deprecated(forRemoval = true)
    @GraphQLNonNull
    @GraphQLQuery(name = "availableFields")
    public GdAvailableFields getAvailableFieldsOld(@GraphQLRootContext GridGraphQLContext context,
                                                   @GraphQLContext GdOperatorAccess access) {
        return operatorDataService.getAvailableFields();
    }

    /**
     * GraphQL запрос. Получить данные о разрешенных для оператора полях
     */
    @GraphQLNonNull
    @GraphQLQuery(name = "availableFields")
    public GdAvailableFields getAvailableFields(@GraphQLRootContext GridGraphQLContext context,
                                                @GraphQLContext GdOperatorInfo operator) {
        return operatorDataService.getAvailableFields();
    }

    /**
     * GraphQL-запрос. Записать сессию и понять, не пора ли показать ФОС
     */
    @GraphQLNonNull
    @GraphQLQuery(name = "shouldOpenFeedbackForm")
    public boolean shouldOpenFeedbackForm(@GraphQLRootContext GridGraphQLContext context) {
        return operatorDataService.shouldOpenFeedbackForm(context.getOperator());
    }

    /**
     * GraphQL-мутация. Забыть предыдущие сессии, записать флаг rateLater в настройки пользователя
     */
    @GraphQLNonNull
    @GraphQLMutation(name = "feedbackRateLater")
    public GdFeedbackRateLaterPayload feedbackRateLater(@GraphQLRootContext GridGraphQLContext context) {
        operatorDataService.feedbackRateLater(context.getOperator());
        return new GdFeedbackRateLaterPayload();
    }

    /**
     * GraphQL-мутация. Забыть предыдущие сессии, записать факт показа формы обратной связи
     */
    @GraphQLNonNull
    @GraphQLMutation(name = "feedbackMarkAsShown")
    public GdFeedbackRateLaterPayload feedbackMarkAsShown(@GraphQLRootContext GridGraphQLContext context) {
        operatorDataService.feedbackMarkAsShown(context.getOperator());
        return new GdFeedbackRateLaterPayload(); // это тоже «позже», только сильно позже
    }
}
