package ru.yandex.direct.grid.processing.service.operator;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.grid.processing.model.client.GdClientRepresentativeType;
import ru.yandex.direct.grid.processing.model.client.GdUserInfo;
import ru.yandex.direct.rbac.RbacRepType;

@ParametersAreNonnullByDefault
public class UserDataConverter {
    //Детали про аватарки Yapic описаны здес: https://wiki.yandex-team.ru/yapic/
    @SuppressWarnings("SpellCheckingInspection")
    static final String USER_YAPIC_AVATAR_TEMPLATE = "https://avatars.mds.yandex.net/get-yapic/%1$d/islands-50";

    public static GdUserInfo toGdUserInfo(User userInfo) {
        return new GdUserInfo()
                .withClientId(userInfo.getClientId().asLong())
                .withUserId(userInfo.getUid())
                .withName(userInfo.getFio())
                .withLogin(userInfo.getLogin())
                .withEmail(userInfo.getEmail())
                .withPhone(userInfo.getPhone())
                .withAvatarUrl(getAvatarUrl(userInfo.getUid()))
                .withMetrikaCountersNum(userInfo.getMetrikaCountersNum())
                .withRepresentativeType(toGdClientRepresentativeType(userInfo.getRepType()));
    }

    protected static GdClientRepresentativeType toGdClientRepresentativeType(RbacRepType rbacRepType) {
        switch (rbacRepType) {
            case CHIEF:
                return GdClientRepresentativeType.CHIEF;
            case MAIN:
                return GdClientRepresentativeType.MAIN;
            case LIMITED:
                return GdClientRepresentativeType.LIMITED;
            case READONLY:
                return GdClientRepresentativeType.READONLY;
            default:
                throw new IllegalArgumentException("Unknown reptype: " + rbacRepType);
        }
    }

    public static String getAvatarUrl(Long uid) {
        return String.format(USER_YAPIC_AVATAR_TEMPLATE, uid);
    }
}
