package ru.yandex.direct.grid.processing.service.operator;


import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import org.dataloader.DataLoader;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.grid.processing.model.client.GdUserInfo;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;

import static java.util.stream.Collectors.toList;

/**
 * {@link DataLoader} для отложенной batch'евой загрузки информации о пользователях
 *
 * @see GridBatchingDataLoader
 * @see ru.yandex.direct.grid.processing.service.dataloader.GridDataLoaderRegistry
 */
@Component
// DataLoader'ы хранят состояние, поэтому жить должны в рамках запроса
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class UserDataLoader extends GridBatchingDataLoader<Long, GdUserInfo> {

    public UserDataLoader(OperatorDataService operatorDataService) {
        dataLoader = dataLoader(keys -> {
            Map<Long, GdUserInfo> usersByUid = operatorDataService.getUsersByIds(keys);
            // По контракту возвращаем список объектов в порядке, соответствующем ключам
            // Возможно, будет удобнее, когда решится внешний PR "Map as batch result" https://github.com/graphql-java/java-dataloader/pull/25
            List<GdUserInfo> collect = keys.stream()
                    .map(usersByUid::get)
                    .collect(toList());
            return CompletableFuture.completedFuture(collect);
        });
    }
}
