package ru.yandex.direct.grid.processing.service.pricepackage;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.abac.Attribute;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.pricepackage.GdGetMarkupConditions;
import ru.yandex.direct.grid.processing.model.pricepackage.GdGetMarkupConditionsPayload;
import ru.yandex.direct.grid.processing.model.pricepackage.mutation.GdAddMarkupConditions;
import ru.yandex.direct.grid.processing.model.pricepackage.mutation.GdAddMarkupConditionsPayload;
import ru.yandex.direct.grid.processing.model.pricepackage.mutation.GdDeleteMarkupConditions;
import ru.yandex.direct.grid.processing.model.pricepackage.mutation.GdDeleteMarkupConditionsPayload;
import ru.yandex.direct.grid.processing.model.pricepackage.mutation.GdUpdateMarkupConditions;
import ru.yandex.direct.grid.processing.model.pricepackage.mutation.GdUpdateMarkupConditionsPayload;
import ru.yandex.direct.web.annotations.RequiredAttributes;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class MarkupConditionGraphQlService {
    private final MarkupConditionDataService markupConditionDataService;

    @Autowired
    public MarkupConditionGraphQlService(
            MarkupConditionDataService markupConditionDataService) {
        this.markupConditionDataService = markupConditionDataService;
    }

    @GraphQLQuery(name = "getMarkupConditions", description = "Получение наценок за таргеты")
    @RequiredAttributes(Attribute.CAN_OPEN_PRICE_PACKAGE_GRID)
    public GdGetMarkupConditionsPayload getMarkupConditions(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdGetMarkupConditions input) {
        return markupConditionDataService.getMarkupConditions(input);
    }

    @GraphQLMutation(name = "addMarkupConditions", description = "Создание условий применения наценок за таргеты")
    @RequiredAttributes(Attribute.MANAGE_PRICE_PACKAGES)
    public GdAddMarkupConditionsPayload addMarkupConditions(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdAddMarkupConditions input) {
        return markupConditionDataService.addMarkupConditions(input);
    }

    @GraphQLMutation(name = "updateMarkupConditions", description = "Обновление условий наценок за таргеты")
    @RequiredAttributes({Attribute.MANAGE_PRICE_PACKAGES})
    public GdUpdateMarkupConditionsPayload updateMarkupConditions(
            @GraphQLNonNull @GraphQLArgument(name = "input") GdUpdateMarkupConditions input) {
        return markupConditionDataService.updateMarkupConditions(input);
    }

    @GraphQLMutation(name = "deleteMarkupConditions", description = "Удаление условий наценок за таргеты")
    @RequiredAttributes(Attribute.MANAGE_PRICE_PACKAGES)
    public GdDeleteMarkupConditionsPayload deleteMarkupConditions(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdDeleteMarkupConditions input) {
        return markupConditionDataService.deleteMarkupConditions(input);
    }

}
