package ru.yandex.direct.grid.processing.service.pricepackage;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.core.entity.user.service.UserService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;
import ru.yandex.direct.grid.processing.service.dataloader.GridContextProvider;

import static ru.yandex.direct.utils.FunctionalUtils.mapSet;

@Component
// DataLoader'ы хранят состояние, поэтому жить должны в рамках запроса
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
@ParametersAreNonnullByDefault
public class PricePackageClientLoginDataLoader extends GridBatchingDataLoader<Long, String> {

    @Autowired
    public PricePackageClientLoginDataLoader(GridContextProvider gridContextProvider, UserService userService) {
        dataLoader = mappedDataLoader(gridContextProvider, (keys, environment) -> {
            Set<ClientId> clientIds = mapSet(keys, ClientId::fromLong);
            Map<ClientId, String> chiefLogins = userService.getChiefsLoginsByClientIds(clientIds);
            Map<Long, String> result = EntryStream.of(chiefLogins)
                    .mapKeys(ClientId::asLong)
                    .toMap();
            return CompletableFuture.completedFuture(result);
        });
    }
}
