package ru.yandex.direct.grid.processing.service.pricepackage;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.pricepackage.GdGetPricePackageAdGroupMarkups;
import ru.yandex.direct.grid.processing.model.pricepackage.GdGetPricePackageAdGroupMarkupsPayload;
import ru.yandex.direct.grid.processing.model.pricepackage.GdGetPricePackageCampaignBudget;
import ru.yandex.direct.grid.processing.model.pricepackage.GdPricePackageCampaignBudgetPayload;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class PricePackageMarkupGraphQlService {
    private final PricePackageMarkupDataService pricePackageMarkupDataService;

    @Autowired
    public PricePackageMarkupGraphQlService(
            PricePackageMarkupDataService pricePackageMarkupDataService) {
        this.pricePackageMarkupDataService = pricePackageMarkupDataService;
    }

    @PreAuthorizeRead
    @GraphQLQuery(name = "getPricePackageMarkups",
            description = "Получение итогового CPM для группы с учетом пакетных наценок")
    public GdGetPricePackageAdGroupMarkupsPayload getPricePackageMarkups(
            @GraphQLArgument(name = "input") GdGetPricePackageAdGroupMarkups input,
            @GraphQLRootContext GridGraphQLContext context) {
        return pricePackageMarkupDataService.getPricePackageMarkups(context.getSubjectUser().getClientId(), input.getItems());
    }

    @PreAuthorizeRead
    @GraphQLQuery(name = "getPricePackageCampaignBudget",
            description = "Получение итогового бюджета для кампании с учетом пакетных сезонных наценок")
    public GdPricePackageCampaignBudgetPayload getPricePackageCampaignBudget(
            @GraphQLArgument(name = "input") GdGetPricePackageCampaignBudget input,
            @GraphQLRootContext GridGraphQLContext context) {
        return pricePackageMarkupDataService.getPricePackageCampaignBudget(context.getSubjectUser().getClientId(), input);
    }
}
