package ru.yandex.direct.grid.processing.service.pricepackage;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.abac.Attribute;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.pricepackage.GdGetProjectParamConditions;
import ru.yandex.direct.grid.processing.model.pricepackage.GdGetProjectParamConditionsPayload;
import ru.yandex.direct.grid.processing.model.pricepackage.mutation.GdAddProjectParamConditions;
import ru.yandex.direct.grid.processing.model.pricepackage.mutation.GdAddProjectParamConditionsPayload;
import ru.yandex.direct.grid.processing.model.pricepackage.mutation.GdDeleteProjectParamConditions;
import ru.yandex.direct.grid.processing.model.pricepackage.mutation.GdDeleteProjectParamConditionsPayload;
import ru.yandex.direct.grid.processing.model.pricepackage.mutation.GdUpdateProjectParamConditions;
import ru.yandex.direct.grid.processing.model.pricepackage.mutation.GdUpdateProjectParamConditionsPayload;
import ru.yandex.direct.web.annotations.RequiredAttributes;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class ProjectParamConditionGraphQlService {
    private final ProjectParamConditionDataService projectParamConditionDataService;

    @Autowired
    public ProjectParamConditionGraphQlService(
            ProjectParamConditionDataService projectParamConditionDataService) {
        this.projectParamConditionDataService = projectParamConditionDataService;
    }

    @GraphQLQuery(name = "getProjectParamConditions", description = "Получение наценок за таргеты")
    public GdGetProjectParamConditionsPayload getProjectParamConditions(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdGetProjectParamConditions input) {
        return projectParamConditionDataService.getProjectParamConditions(input);
    }

    @GraphQLMutation(name = "addProjectParamConditions", description = "Создание формул таргетинга на параметры проектов")
    @RequiredAttributes(Attribute.MANAGE_PRICE_PACKAGES)
    public GdAddProjectParamConditionsPayload addProjectParamConditions(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdAddProjectParamConditions input) {
        return projectParamConditionDataService.addProjectParamConditions(input);
    }

    @GraphQLMutation(name = "updateProjectParamConditions", description = "Обновление формул таргетинга на параметры проектов")
    @RequiredAttributes({Attribute.MANAGE_PRICE_PACKAGES})
    public GdUpdateProjectParamConditionsPayload updateProjectParamConditions(
            @GraphQLNonNull @GraphQLArgument(name = "input") GdUpdateProjectParamConditions input) {
        return projectParamConditionDataService.updateProjectParamConditions(input);
    }

    @GraphQLMutation(name = "deleteProjectParamConditions", description = "Удаление формул таргетинга на параметры проектов")
    @RequiredAttributes(Attribute.MANAGE_PRICE_PACKAGES)
    public GdDeleteProjectParamConditionsPayload deleteProjectParamConditions(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdDeleteProjectParamConditions input) {
        return projectParamConditionDataService.deleteProjectParamConditions(input);
    }

}
