package ru.yandex.direct.grid.processing.service.product;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.product.GdProduct;
import ru.yandex.direct.grid.processing.model.product.GdProductContainer;
import ru.yandex.direct.grid.processing.model.product.GdProductContext;

/**
 * Сервис, возвращающий данные о продуктах
 */
@GridGraphQLService
@ParametersAreNonnullByDefault
public class ProductGraphQlService {
    private static final String PRODUCTS_RESOLVER_NAME = "products";

    private final ProductDataService productDataService;

    @Autowired
    public ProductGraphQlService(ProductDataService productDataService) {
        this.productDataService = productDataService;
    }

    /**
     * GraphQL подзапрос. Получает справочник продуктов
     *
     * @param input   параметры фильтра и вывода
     */
    @GraphQLNonNull
    @GraphQLQuery(name = PRODUCTS_RESOLVER_NAME)
    public GdProductContext getProducts(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdProductContainer input) {
        List<GdProduct> gdProducts = productDataService.getProducts(context.getSubjectUser().getClientId(), input);

        return new GdProductContext()
                .withRowset(gdProducts)
                .withTotalCount(gdProducts.size());
    }
}
