package ru.yandex.direct.grid.processing.service.promoextension

import ru.yandex.direct.core.entity.promoextension.model.DataToExtractPromoExtensionCompoundDescription
import ru.yandex.direct.core.entity.promoextension.model.PromoExtension
import ru.yandex.direct.grid.processing.model.promoextension.GdPromoExtension
import ru.yandex.direct.grid.processing.model.promoextension.GdPromoExtensionPrefix
import ru.yandex.direct.grid.processing.model.promoextension.GdPromoExtensionType
import ru.yandex.direct.grid.processing.model.promoextension.GdPromoExtensionUnit

object GdPromoExtensionConverter {
    fun toGdPromoExtension(promoExtension: PromoExtension) = GdPromoExtension(
        id = promoExtension.promoExtensionId!!,
        type = GdPromoExtensionType.fromPromoactionsType(promoExtension.type),
        amount = promoExtension.amount,
        unit = promoExtension.unit?.let { GdPromoExtensionUnit.fromCoreValue(it) },
        prefix = promoExtension.prefix?.let { GdPromoExtensionPrefix.fromPromoactionsPrefix(it) },
        href = promoExtension.href,
        description = promoExtension.description,
        startDate = promoExtension.startDate,
        finishDate = promoExtension.finishDate,
        name = DataToExtractPromoExtensionCompoundDescription(
            type = promoExtension.type,
            amount = promoExtension.amount,
            unit = promoExtension.unit,
            prefix = promoExtension.prefix,
            description = promoExtension.description,
            finishDate = promoExtension.finishDate,//не используем в compoundDescriptionWithoutDate
        ).compoundDescriptionWithoutDate,
        statusModerate = promoExtension.statusModerate,
    )
}
