package ru.yandex.direct.grid.processing.service.promoextension

import ru.yandex.direct.grid.core.util.filters.FilterProcessor
import ru.yandex.direct.grid.core.util.filters.FilterProvider
import ru.yandex.direct.grid.model.Order.ASC
import ru.yandex.direct.grid.model.Order.DESC
import ru.yandex.direct.grid.processing.model.promoextension.GdPromoExtension
import ru.yandex.direct.grid.processing.model.promoextension.GdPromoExtensionFilter
import ru.yandex.direct.grid.processing.model.promoextension.GdPromoExtensionOrderBy
import ru.yandex.direct.grid.processing.model.promoextension.GdPromoExtensionOrderByField
import ru.yandex.direct.grid.processing.model.promoextension.GdPromoExtensionOrderByField.ID
import ru.yandex.direct.grid.processing.model.promoextension.GdPromoExtensionOrderByField.NAME
import ru.yandex.direct.grid.processing.model.promoextension.GdPromoExtensionsContainer
import ru.yandex.direct.grid.processing.service.validation.GridValidationService
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.constraint.StringConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.util.property
import ru.yandex.direct.validation.util.validateObject

object PromoExtensionGraphQlServiceUtils {
    internal val PROMO_EXTENSIONS_CONTAINER_VALIDATOR: Validator<GdPromoExtensionsContainer, Defect<*>> = Validator { container ->
        validateObject(container) {
            property(GdPromoExtensionsContainer::filter) {
                check(CommonConstraints.notNull(), When.isTrue(container.filterKey == null))
                checkBy(
                    Validator { filter: GdPromoExtensionFilter ->
                        validateObject(filter) {
                            property(GdPromoExtensionFilter::promoExtensionIdIn) {
                                checkBy(GridValidationService.IDS_COLLECTION_VALIDATOR, When.notNull())
                            }
                        }
                    }, When.notNull()
                )
            }
            property(GdPromoExtensionsContainer::filterKey) {
                check(CommonConstraints.notNull(), When.isTrue(container.filter == null))
                check(StringConstraints.notBlank(), When.notNull())
            }
            property(GdPromoExtensionsContainer::limitOffset) {
                checkBy(GridValidationService.LIMIT_OFFSET_VALIDATOR)
            }
            property(GdPromoExtensionsContainer::cacheKey) {
                check(StringConstraints.notBlank(), When.notNull())
            }
        }
    }

    internal val PROMO_EXTENSION_FILTER_PROCESSOR = FilterProcessor.Builder<GdPromoExtensionFilter, GdPromoExtension>()
        .withFilter({ it.promoExtensionIdIn }, FilterProvider.contains({ it.id }))
        .withFilter({ it.nameContains }, FilterProvider.isSubStringCU({ it.name }))
        .withFilter({ it.promoExtensionIdContainsAny }, FilterProvider.numericContainsAny({ it.id }))
        .build()

    internal fun getComparator(orderBy: List<GdPromoExtensionOrderBy>): Comparator<GdPromoExtension> {
        if (orderBy.isEmpty()) {
            return getComparator(listOf(GdPromoExtensionOrderBy(ID, DESC))) //дефолтная сортировка=="новые сверху"
        }
        var comparator: Comparator<GdPromoExtension>? = null
        for (item in orderBy) {
            val func = orderByFieldToCompareFunc(item.field)
            val naturalComparator = Comparator.nullsLast(Comparator.naturalOrder<Comparable<Any>>())
            var currentComparator = Comparator { a: GdPromoExtension, b: GdPromoExtension -> naturalComparator.compare(func.invoke(a), func.invoke(b)) }
            currentComparator = if (item.order == ASC) currentComparator else currentComparator.reversed()
            comparator = if (comparator == null) {
                currentComparator
            } else {
                comparator.thenComparing(currentComparator)
            }
        }
        return comparator!!
    }

    private fun orderByFieldToCompareFunc(orderBy: GdPromoExtensionOrderByField) =
        when (orderBy) {
            ID -> { promo: GdPromoExtension -> promo.id as Comparable<Any> }
            NAME -> { promo: GdPromoExtension -> promo.name as Comparable<Any> }
        }
}
