package ru.yandex.direct.grid.processing.service.pub.country;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.user.service.BlackboxUserService;
import ru.yandex.direct.grid.processing.annotations.PublicGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.constants.GdNewUserCountry;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;

/**
 * Сервис, возвращающий страну пользователя
 */
@PublicGraphQLService
@ParametersAreNonnullByDefault
public class CountryQlService {
    private final BlackboxUserService blackboxUserService;
    private final DirectWebAuthenticationSource directWebAuthenticationSource;
    @Autowired
    public CountryQlService(BlackboxUserService blackboxUserService,DirectWebAuthenticationSource directWebAuthenticationSource) {
        this.blackboxUserService = blackboxUserService;
        this.directWebAuthenticationSource = directWebAuthenticationSource;
    }

    /**
     * GraphQL подзапрос. Получает информацию о стране пользователя по кукам
     **/
    @GraphQLQuery(name = "getUserPassportCountry", description = "Получить информацию о стране пользователя")
    public GdNewUserCountry getUserPassportCountry(@GraphQLRootContext GridGraphQLContext context) {
        Long operatorUid = context.getOperator().getUid();
        return GdNewUserCountry.fromSource(blackboxUserService.getCountryByUid(operatorUid));
    }
}
