package ru.yandex.direct.grid.processing.service.pub.operator;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.processing.model.pub.operator.GdPublicOperatorInfo;

/**
 * Сервис, возвращающий данные об операторе
 */
@Service
@ParametersAreNonnullByDefault
public class OperatorPublicDataService {

    @Autowired
    public OperatorPublicDataService() {
    }

    public GdPublicOperatorInfo getPublicOperatorInfo(User operator) {
        if (operator.getUid() == 0L) {
            return null;
        }
        ClientId clientId = operator.getClientId();
        return new GdPublicOperatorInfo()
                .withLogin(operator.getLogin())
                .withClientId(clientId == null ? null : clientId.asLong());
    }
}
