package ru.yandex.direct.grid.processing.service.pub.operator;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.grid.processing.annotations.PublicGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.pub.operator.GdPublicOperatorInfo;

/**
 * Сервис, отдающий информацию об операторе, выполняющем запрос в публичный GraphQL
 */
@PublicGraphQLService
@ParametersAreNonnullByDefault
public class OperatorPublicGraphQlService {
    private final OperatorPublicDataService operatorDataService;

    @Autowired
    public OperatorPublicGraphQlService(
            OperatorPublicDataService operatorDataService) {
        this.operatorDataService = operatorDataService;
    }

    @GraphQLQuery(name = "operator")
    public GdPublicOperatorInfo getOperator(@GraphQLRootContext GridGraphQLContext context) {
        User operator = context.getOperator();
        return operatorDataService.getPublicOperatorInfo(operator);
    }

}
