package ru.yandex.direct.grid.processing.service.region;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import ru.yandex.direct.geobasehelper.GeoBaseHelper;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.regions.GeoTreeFactory;
import ru.yandex.direct.regions.GeoTreeType;
import ru.yandex.direct.regions.Region;
import ru.yandex.geobase.CrimeaStatus;

/**
 * Сервис обслуживающий коммерческие регионы директа.
 */
@Service
@ParametersAreNonnullByDefault
public class AdRegionDataService {

    private final GeoBaseHelper geoBaseHelper;
    private final GeoTreeFactory geoTreeFactory;

    public AdRegionDataService(GeoBaseHelper geoBaseHelper, GeoTreeFactory geoTreeFactory) {
        this.geoBaseHelper = geoBaseHelper;
        this.geoTreeFactory = geoTreeFactory;
    }

    @Async("geoBaseTaskExecutor")
    public CompletableFuture<Optional<Region>> findCommercialRegion(double latitude, double longitude) {
        var geoTreeType = getGeoTree().getGeoTreeType();
        var maybeRegionId = geoBaseHelper.getNearestDirectRegionId(latitude, longitude, mapGeoTreeType(geoTreeType));
        return CompletableFuture.completedFuture(maybeRegionId.map(getGeoTree()::getRegion));
    }

    public CrimeaStatus mapGeoTreeType(GeoTreeType geoTreeType) {
        return geoTreeType == GeoTreeType.RUSSIAN ? CrimeaStatus.RU : CrimeaStatus.UA;
    }

    private GeoTree getGeoTree() {
        return geoTreeFactory.getGlobalGeoTree();
    }
}
