package ru.yandex.direct.grid.processing.service.request;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.annotations.PublicGraphQLService;
import ru.yandex.direct.tracing.Trace;
import ru.yandex.direct.web.annotations.AllowedBlockedOperatorOrUser;

/**
 * Сервис, отдающий информацию о запросе
 */
@GridGraphQLService
@PublicGraphQLService
@ParametersAreNonnullByDefault
public class RequestInfoGraphQlService {

    public static final String GET_REQ_ID_RESOLVER_NAME = "getReqId";
    private static final String RESOLVER_DESCRIPTION = "Получить reqId запроса";

    @Autowired
    public RequestInfoGraphQlService() {
    }

    /**
     * GraphQL запрос и мутация. Получить reqId запроса
     * Фронту нужно получать reqId как для запросов так и для мутаций через схему: DIRECT-87751
     */
    @AllowedBlockedOperatorOrUser
    @GraphQLNonNull
    @GraphQLQuery(name = GET_REQ_ID_RESOLVER_NAME, description = RESOLVER_DESCRIPTION)
    @GraphQLMutation(name = GET_REQ_ID_RESOLVER_NAME, description = RESOLVER_DESCRIPTION)
    public String getReqId() {
        return String.valueOf(Trace.current().getParentId());
    }

}
