package ru.yandex.direct.grid.processing.service.shortener;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.processing.annotations.EnableLoggingOnValidationIssues;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.shortener.GdSaveFilter;
import ru.yandex.direct.grid.processing.model.shortener.GdShortFilter;
import ru.yandex.direct.grid.processing.model.shortener.GdShortFilterUnion;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class ShortenerGraphQlService {
    private final GridShortenerService gridShortenerService;

    @Autowired
    public ShortenerGraphQlService(GridShortenerService gridShortenerService) {
        this.gridShortenerService = gridShortenerService;
    }

    //saveFilterWithKey — актуальный
    @Deprecated
    @GraphQLNonNull
    @PreAuthorizeRead
    @EnableLoggingOnValidationIssues
    @GraphQLMutation(name = "saveFilter")
    public GdShortFilter saveFilter(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdShortFilterUnion input
    ) {
        ClientId clientId = Objects.requireNonNull(context.getSubjectUser()).getClientId();

        return gridShortenerService.saveFilter(clientId, input, null);
    }

    @GraphQLNonNull
    @PreAuthorizeRead
    @EnableLoggingOnValidationIssues
    @GraphQLMutation(name = "saveFilterWithKey")
    public GdShortFilter saveFilterWithKey(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdSaveFilter input
    ) {
        ClientId clientId = Objects.requireNonNull(context.getSubjectUser()).getClientId();

        return gridShortenerService.saveFilter(clientId, input.getFilterUnion(), input.getFilterKey());
    }
}
