package ru.yandex.direct.grid.processing.service.showcondition;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.common.GdResult;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdCreateRetargetingConditionForExperiments;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdCreateRetargetingConditionForExperimentsPayload;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdCreateRetargetingConditionPayloadItem;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdCreateRetargetingConditions;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdDeleteRetargetingConditions;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdDeleteRetargetingConditionsPayloadItem;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdDeleteRetargetings;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdDeleteRetargetingsPayloadItem;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdResumeRetargetings;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdResumeRetargetingsPayloadItem;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdSuspendRetargetings;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdSuspendRetargetingsPayloadItem;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdUpdateRetargetingConditionPayloadItem;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdUpdateRetargetingConditions;
import ru.yandex.direct.grid.processing.service.showcondition.retargeting.RetargetingDataService;

/**
 * Сервис, работающий с условиями ретаргетинга клиента
 */
@GridGraphQLService
@ParametersAreNonnullByDefault
public class RetargetingMutationsGraphQlService {
    private final RetargetingDataService retargetingDataService;

    @Autowired
    public RetargetingMutationsGraphQlService(RetargetingDataService retargetingDataService) {
        this.retargetingDataService = retargetingDataService;
    }


    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "createRetargetingConditions")
    public GdResult<GdCreateRetargetingConditionPayloadItem> createRetargetingConditions(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdCreateRetargetingConditions input) {
        return retargetingDataService.createRetargetingConditions(context, input);
    }


    /**
     * Предполагается удалить этот метод после полного перехода на новую схему создания условий ретаргетинга для
     * экспериментов В ТГО. Тикет DIRECT-112091
     */
    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "findOrCreateExperimentsConditions")
    @Deprecated
    public GdCreateRetargetingConditionForExperimentsPayload findOrCreateExperimentsConditions(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdCreateRetargetingConditionForExperiments input) {
        @SuppressWarnings("ConstantConditions")
        ClientId clientId = context.getSubjectUser().getClientId();
        return retargetingDataService.findOrCreateExperimentsRetargetingConditions(clientId, input);
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "updateRetargetingConditions")
    public GdResult<GdUpdateRetargetingConditionPayloadItem> updateRetargetingConditions(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdUpdateRetargetingConditions input) {
        return retargetingDataService.updateRetargetingConditions(context, input);
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "deleteRetargetingConditions")
    public GdResult<GdDeleteRetargetingConditionsPayloadItem> deleteRetargetingConditions(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdDeleteRetargetingConditions input) {
        return retargetingDataService.deleteRetargetingConditions(context, input);
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "suspendRetargetings")
    public GdResult<GdSuspendRetargetingsPayloadItem> suspendRetargetings(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdSuspendRetargetings input) {
        return retargetingDataService.suspendRetargetings(context, input);
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "resumeRetargetings")
    public GdResult<GdResumeRetargetingsPayloadItem> resumeRetargetings(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdResumeRetargetings input) {
        return retargetingDataService.resumeRetargetings(context, input);
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "deleteRetargetings")
    public GdResult<GdDeleteRetargetingsPayloadItem> deleteRetargetings(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdDeleteRetargetings input) {
        return retargetingDataService.deleteRetargetings(context, input);
    }
}
