package ru.yandex.direct.grid.processing.service.showcondition;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

import ru.yandex.direct.grid.processing.model.showcondition.GdShowConditionStatItem;
import ru.yandex.direct.grid.processing.model.showcondition.GdShowConditionTotals;
import ru.yandex.direct.intapi.client.model.response.statistics.CampaignStatisticsItem;

import static ru.yandex.direct.utils.CommonUtils.nullableNvl;
import static ru.yandex.direct.utils.CommonUtils.nvl;

public final class ShowConditionTotals {

    static GdShowConditionTotals totalsFromCampaignStatisticItem(CampaignStatisticsItem item) {
        return new GdShowConditionTotals()
                .withClicks(BigDecimal.valueOf(nvl(
                        nullableNvl(item.getClicks(), item.getClicksA()),
                        0L
                )))
                .withShows(BigDecimal.valueOf(nvl(
                        nullableNvl(item.getShows(), item.getShowsA()),
                        0L
                )))
                .withConversions(BigDecimal.valueOf(nvl(
                        nullableNvl(item.getConversions(), item.getConversionsA()),
                        0L
                )))
                .withCost(BigDecimal.valueOf(nvl(
                        nullableNvl(item.getCost(), item.getCostA()),
                        0.0
                )))
                .withCostPerConversion(BigDecimal.valueOf(nvl(
                        nullableNvl(item.getCostPerConversion(), item.getCostPerConversionA()),
                        0.0
                )));
    }

    static GdShowConditionTotals getCategoryTotals(List<GdShowConditionStatItem> items) {
        BigDecimal totalClicks = BigDecimal.ZERO;
        BigDecimal totalShows = BigDecimal.ZERO;
        BigDecimal totalConversions = BigDecimal.ZERO;
        BigDecimal totalCost = BigDecimal.ZERO;

        /* Суммируем только аддитивные величины */
        for (var item : items) {
            totalClicks = totalClicks.add(item.getTotals().getClicks());
            totalShows = totalShows.add(item.getTotals().getShows());
            totalConversions = totalConversions.add(item.getTotals().getConversions());
            totalCost = totalCost.add(item.getTotals().getCost());
        }

        /* Производные величины вычисляем из аддитивных */

        // costPerConversion = cost / conversions
        BigDecimal averageCostPerConversion;
        if (totalConversions.compareTo(BigDecimal.ZERO) == 0) {
            averageCostPerConversion = BigDecimal.ZERO;
        } else {
            averageCostPerConversion = totalCost.divide(totalConversions, 2, RoundingMode.HALF_UP);
        }

        return new GdShowConditionTotals()
                .withClicks(totalClicks)
                .withShows(totalShows)
                .withConversions(totalConversions)
                .withCost(totalCost)
                .withCostPerConversion(averageCostPerConversion);
    }
}
